/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.hash.streaming.murmur;

import com.jn.langx.util.hash.AbstractHasher;
import com.jn.langx.util.hash.StreamingHasher;
import com.jn.langx.util.hash.streaming.AbstractStreamingHasher;

public class Murmur2Hasher
extends AbstractStreamingHasher {
    private static Murmur2Hasher _instance = new Murmur2Hasher();
    private long h;

    public static StreamingHasher getInstance() {
        return _instance;
    }

    public Murmur2Hasher() {
        this.reset();
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        this.h = seed;
    }

    @Override
    public void update(byte[] bytes, int off, int len) {
        byte[] bs = new byte[len];
        System.arraycopy(bytes, off, bs, 0, len);
        this.h = this.updateInternal(bs, bs.length, this.h);
    }

    @Override
    public long getHash() {
        long r = this.h;
        this.reset();
        return r;
    }

    private long updateInternal(byte[] data, int length, long initValue) {
        int m = 1540483477;
        int r = 24;
        long h = initValue ^ (long)length;
        int len4 = length >> 2;
        for (int i = 0; i < len4; ++i) {
            int i4 = i << 2;
            int k = data[i4 + 3];
            k <<= 8;
            k |= data[i4 + 2] & 0xFF;
            k <<= 8;
            k |= data[i4 + 1] & 0xFF;
            k <<= 8;
            k |= data[i4] & 0xFF;
            k *= m;
            k ^= k >>> r;
            h *= (long)m;
            h ^= (long)(k *= m);
        }
        int moduloLength = len4 << 2;
        int left = length - moduloLength;
        if (left != 0) {
            if (left >= 3) {
                h ^= (long)(data[length - 3] << 16);
            }
            if (left >= 2) {
                h ^= (long)(data[length - 2] << 8);
            }
            if (left >= 1) {
                h ^= (long)data[length - 1];
            }
            h *= (long)m;
        }
        h ^= h >>> 13;
        h *= (long)m;
        h ^= h >>> 15;
        return h;
    }

    @Override
    protected AbstractHasher createInstance(Object initParam) {
        return new Murmur2Hasher();
    }
}

