/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.hash.streaming.murmur;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.hash.AbstractHasher;
import com.jn.langx.util.hash.streaming.AbstractStreamingHasher;

public class Murmur3_32Hasher
extends AbstractStreamingHasher {
    private static final int CHUNK_SIZE = 4;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private int h;
    private long buffer;
    private int shift;
    private int length;
    private static final int UNSIGNED_MASK = 255;

    public Murmur3_32Hasher() {
        this.reset();
    }

    @Override
    public void update(byte[] bytes, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, bytes.length);
        int i = 0;
        while (i + 4 <= len) {
            this.update(4, Murmur3_32Hasher.getIntLittleEndian(bytes, off + i));
            i += 4;
        }
        while (i < len) {
            this.update(bytes[off + i]);
            ++i;
        }
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        this.h = (int)seed;
        this.buffer = 0L;
        this.shift = 0;
        this.length = 0;
    }

    @Override
    protected void update(byte b) {
        this.update(1, b & 0xFF);
    }

    @Override
    public long getHash() {
        this.h ^= Murmur3_32Hasher.mixK1((int)this.buffer);
        this.h = Murmur3_32Hasher.fmix(this.h, this.length);
        long r = this.h;
        this.reset();
        return r;
    }

    @Override
    protected AbstractHasher createInstance(Object initParam) {
        return new Murmur3_32Hasher();
    }

    private void update(int nBytes, long update) {
        this.buffer |= (update & 0xFFFFFFFFL) << this.shift;
        this.shift += nBytes * 8;
        this.length += nBytes;
        if (this.shift >= 32) {
            this.h = Murmur3_32Hasher.mixH1(this.h, Murmur3_32Hasher.mixK1((int)this.buffer));
            this.buffer >>>= 32;
            this.shift -= 32;
        }
    }

    private static int fmix(int h1, int length) {
        h1 ^= length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    private static int toInt(byte value) {
        return value & 0xFF;
    }

    private static int getIntLittleEndian(byte[] input, int offset) {
        return Murmur3_32Hasher.fromBytes(input[offset + 3], input[offset + 2], input[offset + 1], input[offset]);
    }

    private static int fromBytes(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }
}

