/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.id;

import com.jn.langx.annotation.IntLimit;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.NotEmpty;
import com.jn.langx.util.Maths;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.concurrent.threadlocal.GlobalThreadLocalMap;
import com.jn.langx.util.function.Function3;
import com.jn.langx.util.random.BytesRandom;

public class Nanoids {
    public static final Function3<String, Integer, BytesRandom, String> STEP_ID_FUN = new Function3<String, Integer, BytesRandom, String>(){

        @Override
        public String apply(String alphabet, Integer expectedIdLength, BytesRandom randomBytesSupplier) {
            if (randomBytesSupplier == null) {
                randomBytesSupplier = GlobalThreadLocalMap.pooledBytesRandom();
            }
            int mask = (2 << 31 - Maths.clz32(alphabet.length() - 1 | 1)) - 1;
            int step = (int)Math.ceil(1.6 * (double)mask * (double)expectedIdLength.intValue() / (double)alphabet.length());
            StringBuilder id = new StringBuilder();
            block0: while (true) {
                byte[] bytes = randomBytesSupplier.get(step);
                int i = step;
                do {
                    if (i-- <= 0) continue block0;
                    int index = bytes[i] & mask;
                    id.append(index >= alphabet.length() ? "" : Character.valueOf(alphabet.charAt(index)));
                } while (id.length() != expectedIdLength.intValue());
                break;
            }
            return id.toString();
        }
    };
    public static final Function3<String, Integer, BytesRandom, String> SIMPLE_ID_FUN = new Function3<String, Integer, BytesRandom, String>(){

        @Override
        public String apply(String alphabet, Integer expectedIdLength, BytesRandom randomBytesSupplier) {
            if (randomBytesSupplier == null) {
                randomBytesSupplier = GlobalThreadLocalMap.pooledBytesRandom();
            }
            byte[] randomBytes = randomBytesSupplier.get(expectedIdLength);
            StringBuilder b = new StringBuilder();
            int mask = alphabet.length() - 1;
            for (int i = 0; i < expectedIdLength; ++i) {
                int index = randomBytes[i] & mask;
                b.append(index >= alphabet.length() ? "" : Character.valueOf(alphabet.charAt(index)));
            }
            return b.toString();
        }
    };
    public static final String URL_ALPHABET = "useandom-26T198340PX75pxJACKVERYMINDBUSHWOLF_GQZbfghjklqvwyzrict";
    public static final String DEFAULT_ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    private Nanoids() {
    }

    public static String urlNanoid() {
        return Nanoids.urlNanoid(21);
    }

    public static String urlNanoid(int expectedIdLength) {
        return Nanoids.nanoid(URL_ALPHABET, expectedIdLength);
    }

    public static String nanoid(@NotEmpty String alphabet, @IntLimit(value=21, min=1) int expectedIdLength) {
        return Nanoids.nanoid(alphabet, expectedIdLength, GlobalThreadLocalMap.pooledBytesRandom(), SIMPLE_ID_FUN);
    }

    public static String nanoid(@NotEmpty String alphabet, @IntLimit(value=21, min=1) int expectedIdLength, @NonNull Function3<String, Integer, BytesRandom, String> idGenFun) {
        return Nanoids.nanoid(alphabet, expectedIdLength, GlobalThreadLocalMap.pooledBytesRandom(), idGenFun);
    }

    public static String nanoid(@NotEmpty String alphabet, @IntLimit(value=21, min=1) int expectedIdLength, @NonNull BytesRandom randomBytesSupplier, @NonNull Function3<String, Integer, BytesRandom, String> idGenFun) {
        if (expectedIdLength < 1) {
            expectedIdLength = 21;
        }
        if (Objs.isEmpty(alphabet)) {
            alphabet = DEFAULT_ALPHABET;
        }
        Preconditions.checkNotNullArgument(randomBytesSupplier, "randomBytesSupplier");
        Preconditions.checkNotNullArgument(idGenFun, "idGenFun");
        return idGenFun.apply(alphabet, expectedIdLength, randomBytesSupplier);
    }
}

