/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.id;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.UUID;

public final class ShortUuid {
    private final String uuid;

    private ShortUuid(String uuid) {
        this.uuid = uuid;
    }

    public String toString() {
        return this.uuid;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShortUuid)) {
            return false;
        }
        return o.toString().equals(this.uuid);
    }

    public static String shortUuid() {
        Builder builder = new Builder();
        ShortUuid shortUuid = builder.build(UUID.randomUUID());
        return shortUuid.toString();
    }

    public static UUID toUUID(String shortUuid) {
        Builder builder = new Builder();
        return UUID.fromString(builder.decode(shortUuid));
    }

    public static class Builder {
        private char[] alphabet = "23456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
        private int alphabetSize = this.alphabet.length;

        public Builder alphabet(String alphabet) {
            this.alphabet = alphabet.toCharArray();
            Arrays.sort(this.alphabet);
            this.alphabetSize = this.alphabet.length;
            return this;
        }

        public ShortUuid build() {
            return this.build(UUID.randomUUID());
        }

        public ShortUuid build(UUID uuid) {
            String uuidStr = uuid.toString().replaceAll("-", "");
            double factor = Math.log(25.0) / Math.log(this.alphabetSize);
            double length = Math.ceil(factor * 16.0);
            BigInteger number = new BigInteger(uuidStr, 16);
            String encoded = this.encode(number, this.alphabet, (int)length);
            return new ShortUuid(encoded);
        }

        public String decode(String shortUuid) {
            return this.decode(shortUuid.toCharArray(), this.alphabet);
        }

        private String encode(BigInteger bigInt, char[] alphabet, int padToLen) {
            BigInteger value = new BigInteger(bigInt.toString());
            BigInteger alphaSize = BigInteger.valueOf(this.alphabetSize);
            StringBuilder shortUuid = new StringBuilder();
            while (value.compareTo(BigInteger.ZERO) > 0) {
                BigInteger[] fracAndRemainder = value.divideAndRemainder(alphaSize);
                shortUuid.append(alphabet[fracAndRemainder[1].intValue()]);
                value = fracAndRemainder[0];
            }
            if (padToLen > 0) {
                int padding = Math.max(padToLen - shortUuid.length(), 0);
                for (int i = 0; i < padding; ++i) {
                    shortUuid.append(alphabet[0]);
                }
            }
            return shortUuid.toString();
        }

        private String decode(char[] encoded, char[] alphabet) {
            BigInteger sum = BigInteger.ZERO;
            BigInteger alphaSize = BigInteger.valueOf(this.alphabetSize);
            int charLen = encoded.length;
            for (int i = 0; i < charLen; ++i) {
                sum = sum.add(alphaSize.pow(i).multiply(BigInteger.valueOf(Arrays.binarySearch(alphabet, encoded[i]))));
            }
            String str = sum.toString(16);
            if (str.length() < 32) {
                str = String.format("%32s", str).replace(' ', '0');
            }
            String sb = str.substring(0, 8) + "-" + str.substring(8, 12) + "-" + str.substring(12, 16) + "-" + str.substring(16, 20) + "-" + str.substring(20, 32);
            return sb;
        }
    }
}

