/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.id.snowflake;

import com.jn.langx.cache.Cache;
import com.jn.langx.cache.CacheBuilder;
import com.jn.langx.cache.FIFOCache;
import com.jn.langx.util.id.snowflake.SnowflakeIdWorker;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class CnblogsSnowflakeIdWorker
extends SnowflakeIdWorker {
    private static final long twepoch = 1420041600000L;
    private static final long workerIdBits = 5L;
    private static final long datacenterIdBits = 5L;
    private static final long maxWorkerId = 31L;
    private static final long maxDatacenterId = 31L;
    private static final long sequenceBits = 12L;
    private static final long workerIdShift = 12L;
    private static final long datacenterIdShift = 17L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 4095L;
    private long workerId;
    private long datacenterId;
    private AtomicLong sequence = new AtomicLong(0L);
    private long lastTimestamp = -1L;
    private static final Cache<Long, Long> cache = CacheBuilder.newBuilder().cacheClass(FIFOCache.class).maxCapacity(1000).initialCapacity(10).build();

    public CnblogsSnowflakeIdWorker(long workerId, long dataCenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.datacenterId = dataCenterId;
    }

    @Override
    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp - timestamp == 0L) {
            long sequence = this.sequence.incrementAndGet() & 0xFFFL;
            if (sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence.set(0L);
        }
        this.lastTimestamp = timestamp;
        long id = timestamp - 1420041600000L << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence.get();
        Long idInCache = cache.getIfPresent(id);
        if (idInCache != null && idInCache != 0L) {
            throw new IllegalStateException("the id has exists in the cache, may be your worker is not unique, please check it");
        }
        cache.set(id, id, 10L, TimeUnit.SECONDS);
        return id;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }
}

