/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.id.snowflake;

import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.id.snowflake.SnowflakeIdWorkerProvider;
import com.jn.langx.util.id.snowflake.SystemEnvironmentSnowflakeIdWorkerProvider;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.spi.CommonServiceProvider;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class SnowflakeIdWorkerProviderLoader {
    private static final SnowflakeIdWorkerProvider DEFAULT_PROVIDER = new SystemEnvironmentSnowflakeIdWorkerProvider();
    private static volatile boolean loaded = false;
    private static final Map<String, SnowflakeIdWorkerProvider> LOADED_PROVIDER_MAP = new HashMap<String, SnowflakeIdWorkerProvider>();

    private SnowflakeIdWorkerProviderLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static SnowflakeIdWorkerProvider getProvider() {
        if (!loaded) {
            Class<SnowflakeIdWorkerProviderLoader> clazz = SnowflakeIdWorkerProviderLoader.class;
            // MONITORENTER : com.jn.langx.util.id.snowflake.SnowflakeIdWorkerProviderLoader.class
            if (!loaded) {
                Collects.forEach(CommonServiceProvider.loadService(SnowflakeIdWorkerProvider.class), new Consumer<SnowflakeIdWorkerProvider>(){

                    @Override
                    public void accept(SnowflakeIdWorkerProvider provider) {
                        if (provider.getProviderId().equals("SYSTEM_ENVIRONMENT_SNOWFLAKE")) {
                            LOADED_PROVIDER_MAP.put(provider.getProviderId(), provider);
                        }
                    }
                });
                loaded = true;
                Logger logger = Loggers.getLogger(SnowflakeIdWorkerProviderLoader.class);
                if (LOADED_PROVIDER_MAP.isEmpty()) {
                    logger.warn("Has not any SnowflakeIdWorkerProvider found, will use the SystemEnvironmentSnowflakeIdWorkerProvider: {}", LOADED_PROVIDER_MAP.keySet());
                } else if (LOADED_PROVIDER_MAP.size() > 1) {
                    logger.warn("Too many SnowflakeIdWorkerProvider instances found: {}, will use the first", LOADED_PROVIDER_MAP.keySet());
                }
            }
            // MONITOREXIT : clazz
        }
        if (!LOADED_PROVIDER_MAP.isEmpty()) return LOADED_PROVIDER_MAP.get(Collects.asList(LOADED_PROVIDER_MAP.keySet()).get(0));
        return DEFAULT_PROVIDER;
    }
}

