/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.io.stream.DelimiterBasedReadableByteChannel;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.struct.Holder;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;

public class Channels {
    private Channels() {
    }

    public static void readUsingDelimiter(@NonNull InputStream inputStream, @NonNull String delimiter, @NonNull Consumer2<Integer, byte[]> consumer) {
        Channels.readUsingDelimiter(inputStream, delimiter, null, consumer, null);
    }

    public static void readUsingDelimiter(@NonNull InputStream inputStream, @NonNull String delimiter, final @NonNull Consumer<byte[]> consumer) {
        Channels.readUsingDelimiter(inputStream, delimiter, null, new Consumer2<Integer, byte[]>(){

            @Override
            public void accept(Integer key, byte[] value) {
                consumer.accept(value);
            }
        }, null);
    }

    public static void readUsingDelimiter(@NonNull InputStream inputStream, @NonNull String delimiter, @Nullable Predicate2<Integer, byte[]> consumePredicate, @NonNull Consumer2<Integer, byte[]> consumer, @Nullable Predicate2<Integer, byte[]> breakPredicate) {
        Channels.readUsingDelimiter(java.nio.channels.Channels.newChannel(inputStream), delimiter, consumePredicate, consumer, breakPredicate);
    }

    public static void readUsingDelimiter(@NonNull ReadableByteChannel channel, @NonNull String delimiter, @NonNull Consumer2<Integer, byte[]> consumer) {
        Channels.readUsingDelimiter(channel, delimiter, null, consumer, null);
    }

    public static void readUsingDelimiter(@NonNull ReadableByteChannel channel, @NonNull String delimiter, final @NonNull Consumer<byte[]> consumer) {
        Channels.readUsingDelimiter(channel, delimiter, null, new Consumer2<Integer, byte[]>(){

            @Override
            public void accept(Integer key, byte[] value) {
                consumer.accept(value);
            }
        }, null);
    }

    public static void readUsingDelimiter(@NonNull ReadableByteChannel channel, @NonNull String delimiter, @Nullable Predicate2<Integer, byte[]> consumePredicate, @NonNull Consumer2<Integer, byte[]> consumer, @Nullable Predicate2<Integer, byte[]> breakPredicate) {
        Preconditions.checkNotNull(delimiter);
        Preconditions.checkNotNull(consumer);
        Collects.forEach(new DelimiterBasedReadableByteChannel(channel, delimiter), consumePredicate, consumer, breakPredicate);
    }

    public static void readUsingDelimiter(@NonNull InputStream inputStream, @NonNull String delimiter, @NonNull Charset charset, Consumer<String> consumer) {
        Channels.readUsingDelimiter(java.nio.channels.Channels.newChannel(inputStream), delimiter, charset, consumer);
    }

    public static void readUsingDelimiter(@NonNull InputStream inputStream, @NonNull String delimiter, @NonNull Charset charset, Consumer2<Integer, String> consumer) {
        Channels.readUsingDelimiter(java.nio.channels.Channels.newChannel(inputStream), delimiter, charset, consumer);
    }

    public static void readUsingDelimiter(@NonNull InputStream inputStream, @NonNull String delimiter, @NonNull Charset charset, Predicate2<Integer, String> consumePredicate, Consumer2<Integer, String> consumer, Predicate2<Integer, String> breakConsumer) {
        Channels.readUsingDelimiter(java.nio.channels.Channels.newChannel(inputStream), delimiter, charset, consumePredicate, consumer, breakConsumer);
    }

    public static void readUsingDelimiter(@NonNull ReadableByteChannel channel, @NonNull String delimiter, @NonNull Charset charset, final @NonNull Consumer<String> consumer) {
        Channels.readUsingDelimiter(channel, delimiter, charset, null, new Consumer2<Integer, String>(){

            @Override
            public void accept(Integer index, String value) {
                consumer.accept(value);
            }
        }, null);
    }

    public static void readUsingDelimiter(@NonNull ReadableByteChannel channel, @NonNull String delimiter, @NonNull Charset charset, @NonNull Consumer2<Integer, String> consumer) {
        Preconditions.checkNotNull(charset);
        Channels.readUsingDelimiter(channel, delimiter, Charsets.getDefault(), null, consumer, null);
    }

    public static void readUsingDelimiter(@NonNull ReadableByteChannel channel, final @NonNull String delimiter, final @NonNull Charset charset, final @Nullable Predicate2<Integer, String> consumePredicate, final @NonNull Consumer2<Integer, String> consumer, final @Nullable Predicate2<Integer, String> breakPredicate) {
        Preconditions.checkNotNull(charset);
        final Holder lineValueHolder = new Holder();
        Channels.readUsingDelimiter(channel, delimiter, null, new Consumer2<Integer, byte[]>(){

            @Override
            public void accept(Integer index, byte[] bytes) {
                String str = new String(bytes, charset);
                if (delimiter.equals("\n") && str.endsWith("\r")) {
                    str = str.substring(0, str.length() - 1);
                }
                if (delimiter.equals("\r") && str.startsWith("\n")) {
                    str = str.substring(1);
                }
                if (consumePredicate == null || consumePredicate.test(index, str)) {
                    consumer.accept(index, str);
                }
                lineValueHolder.set(str);
            }
        }, new Predicate2<Integer, byte[]>(){

            @Override
            public boolean test(Integer index, byte[] value) {
                if (breakPredicate == null) {
                    return false;
                }
                return breakPredicate.test(index, lineValueHolder.get());
            }
        });
    }

    public static void readLines(@NonNull InputStream inputStream, @NonNull Consumer<String> consumer) {
        Channels.readLines(inputStream, Charsets.getDefault(), consumer);
    }

    public static void readLines(@NonNull InputStream inputStream, @NonNull Consumer2<Integer, String> consumer) {
        Channels.readLines(inputStream, Charsets.getDefault(), consumer);
    }

    public static void readLines(@NonNull InputStream inputStream, @Nullable Predicate2<Integer, String> consumePredicate, @NonNull Consumer2<Integer, String> consumer, @Nullable Predicate2<Integer, String> breakPredicate) {
        Channels.readLines(inputStream, Charsets.getDefault(), consumePredicate, consumer, breakPredicate);
    }

    public static void readLines(@NonNull InputStream inputStream, @NonNull Charset charset, @NonNull Consumer<String> consumer) {
        Channels.readLines(java.nio.channels.Channels.newChannel(inputStream), charset, consumer);
    }

    public static void readLines(@NonNull InputStream inputStream, @NonNull Charset charset, @NonNull Consumer2<Integer, String> consumer) {
        Channels.readLines(java.nio.channels.Channels.newChannel(inputStream), charset, consumer);
    }

    public static void readLines(@NonNull InputStream inputStream, @NonNull Charset charset, @Nullable Predicate2<Integer, String> consumePredicate, @NonNull Consumer2<Integer, String> consumer, @Nullable Predicate2<Integer, String> breakPredicate) {
        Channels.readLines(java.nio.channels.Channels.newChannel(inputStream), charset, consumePredicate, consumer, breakPredicate);
    }

    public static void readLines(@NonNull ReadableByteChannel channel, @NonNull Consumer<String> consumer) {
        Channels.readLines(channel, Charsets.getDefault(), consumer);
    }

    public static void readLines(@NonNull ReadableByteChannel channel, @NonNull Charset charset, @NonNull Consumer<String> consumer) {
        Preconditions.checkNotNull(charset);
        Preconditions.checkNotNull(consumer);
        Channels.readUsingDelimiter(channel, "\n", charset, consumer);
    }

    public static void readLines(@NonNull ReadableByteChannel channel, @NonNull Charset charset, @NonNull Consumer2<Integer, String> consumer) {
        Preconditions.checkNotNull(charset);
        Preconditions.checkNotNull(consumer);
        Channels.readUsingDelimiter(channel, "\n", charset, consumer);
    }

    public static void readLines(@NonNull ReadableByteChannel channel, @NonNull Charset charset, @Nullable Predicate2<Integer, String> consumePredicate, @NonNull Consumer2<Integer, String> consumer, @Nullable Predicate2<Integer, String> breakPredicate) {
        Preconditions.checkNotNull(charset);
        Preconditions.checkNotNull(consumer);
        Channels.readUsingDelimiter(channel, "\n", charset, consumePredicate, consumer, breakPredicate);
    }
}

