/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Objs;
import com.jn.langx.util.SystemPropertys;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.io.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

public class LineDelimiter {
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String CR_LF = "\r\n";
    public static final LineDelimiter DEFAULT;
    public static final LineDelimiter EOL;
    public static final LineDelimiter CRLF;
    public static final LineDelimiter UNIX;
    public static final LineDelimiter WINDOWS;
    public static final LineDelimiter MAC;
    public static final LineDelimiter NUL;
    private final String value;

    public LineDelimiter(@NonNull String delimiter) {
        this.value = delimiter;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LineDelimiter)) {
            return false;
        }
        LineDelimiter that = (LineDelimiter)o;
        return this.value.equals(that.value);
    }

    public String toString() {
        if (this.value.length() == 0) {
            return "delimiter: auto";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("delimiter:");
        for (int i = 0; i < this.value.length(); ++i) {
            buf.append(" 0x");
            buf.append(Integer.toHexString(this.value.charAt(i)));
        }
        return buf.toString();
    }

    public static boolean isLineDelimiter(final String str) {
        return Pipeline.of(WINDOWS, UNIX, MAC).anyMatch(new Predicate<LineDelimiter>(){

            @Override
            public boolean test(LineDelimiter delimiter) {
                return Objs.equals(delimiter.getValue(), str);
            }
        });
    }

    public static List<LineDelimiter> supportedLineDelimiters() {
        return Pipeline.of(WINDOWS, UNIX, MAC).asList();
    }

    public static List<String> supportedLineDelimiterStrings() {
        return Pipeline.of(LineDelimiter.supportedLineDelimiters()).map(new Function<LineDelimiter, String>(){

            @Override
            public String apply(LineDelimiter lineDelimiter) {
                return lineDelimiter.getValue();
            }
        }).asList();
    }

    static {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)bout, Charsets.UTF_8), true);
        out.println();
        DEFAULT = new LineDelimiter(new String(bout.toByteArray(), Charsets.UTF_8));
        String linesep = SystemPropertys.getLineSeparator();
        EOL = new LineDelimiter(linesep == null ? DEFAULT.getValue() : linesep);
        CRLF = new LineDelimiter(CR_LF);
        UNIX = new LineDelimiter("\n");
        WINDOWS = CRLF;
        MAC = new LineDelimiter("\r");
        NUL = new LineDelimiter("\u0000");
    }
}

