/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io.file;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.os.Platform;
import com.jn.langx.util.reflect.Reflects;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;

public class FileSystems {
    private FileSystems() {
    }

    public static boolean hasFreeSpace(File path, long size) {
        long freeSpace = path.getFreeSpace();
        if (freeSpace == 0L && Platform.isWindows) {
            Logger logger = Loggers.getLogger(FileSystems.class);
            logger.warn("Cannot retrieve free space on {}. This is probably a SUBST'ed drive.", (Object)path);
            return true;
        }
        return freeSpace >= size;
    }

    public static boolean isHidden(File file) {
        Preconditions.checkNotNull(file);
        String name = file.getName();
        return name.startsWith(".");
    }

    public static boolean isNotSymlink(File file) throws IOException {
        return !FileSystems.isSymlink(file);
    }

    public static boolean isSymlink(File file) {
        Preconditions.checkNotNull(file);
        if (Platform.JAVA_VERSION_INT < 7) {
            return false;
        }
        try {
            Class<?> pathClass = Class.forName("java.nio.file.Path");
            Object filePathObject = Reflects.invokePublicMethod(file, "toPath", null, null, true, false);
            return (Boolean)Reflects.invokeAnyStaticMethod("java.nio.file.Files", "isSymbolicLink", new Class[]{pathClass}, new Object[]{filePathObject}, true, false);
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

