/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io.file;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.io.file.OsFileSystem;
import com.jn.langx.util.io.file.validator.FilepathValidators;
import com.jn.langx.util.net.Nets;
import java.io.File;

public class Filenames {
    private static final char UNIX_SEPARATOR = '/';
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String CURRENT_PATH = ".";
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String PARENT_PATH = "..";
    private static final int NOT_FOUND = -1;
    private static final char UNIX_NAME_SEPARATOR = '/';
    private static final char WINDOWS_NAME_SEPARATOR = '\\';

    public static boolean checkFileSegment(String filename) {
        return FilepathValidators.validateName(filename);
    }

    public static boolean checkFilePath(String filePath) {
        return FilepathValidators.validatePath(filePath);
    }

    public static String cleanPath(String path) {
        return Filenames.normalize(path);
    }

    public static String cleanAsUnixPath(String path) {
        String cleaned = Filenames.cleanPath(path);
        return Filenames.asUnixFilePath(cleaned);
    }

    public static String normalize(String fileName) {
        return Filenames.doNormalize(fileName, File.separatorChar, true);
    }

    static char flipSeparator(char ch) {
        if (ch == '/') {
            return '\\';
        }
        if (ch == '\\') {
            return '/';
        }
        throw new IllegalArgumentException(String.valueOf(ch));
    }

    private static String doNormalize(String fileName, char separator, boolean keepSeparator) {
        int i;
        if (fileName == null) {
            return null;
        }
        Filenames.requireNonNullChars(fileName);
        int size = fileName.length();
        if (size == 0) {
            return fileName;
        }
        int prefix = Filenames.getPrefixLength(fileName);
        if (prefix < 0) {
            return null;
        }
        char[] array = new char[size + 2];
        fileName.getChars(0, fileName.length(), array, 0);
        char otherSeparator = Filenames.flipSeparator(separator);
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] != otherSeparator) continue;
            array[i2] = separator;
        }
        boolean lastIsDirectory = true;
        if (array[size - 1] != separator) {
            array[size++] = separator;
            lastIsDirectory = false;
        }
        int n = i = prefix != 0 ? prefix : 1;
        while (i < size) {
            if (array[i] == separator && array[i - 1] == separator) {
                System.arraycopy(array, i, array, i - 1, size - i);
                --size;
                --i;
            }
            ++i;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != separator || array[i - 1] != '.' || i != prefix + 1 && array[i - 2] != separator) continue;
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            System.arraycopy(array, i + 1, array, i - 1, size - i);
            size -= 2;
            --i;
        }
        block3: for (i = prefix + 2; i < size; ++i) {
            if (array[i] != separator || array[i - 1] != '.' || array[i - 2] != '.' || i != prefix + 2 && array[i - 3] != separator) continue;
            if (i == prefix + 2) {
                return null;
            }
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            for (int j = i - 4; j >= prefix; --j) {
                if (array[j] != separator) continue;
                System.arraycopy(array, i + 1, array, j + 1, size - i);
                size -= i - j;
                i = j + 1;
                continue block3;
            }
            System.arraycopy(array, i + 1, array, prefix, size - i);
            size -= i + 1 - prefix;
            i = prefix + 1;
        }
        if (size <= 0) {
            return "";
        }
        if (size <= prefix) {
            return new String(array, 0, size);
        }
        if (lastIsDirectory && keepSeparator) {
            return new String(array, 0, size);
        }
        return new String(array, 0, size - 1);
    }

    public static String normalize(String fileName, boolean unixSeparator) {
        return Filenames.doNormalize(fileName, Filenames.toSeparator(unixSeparator), true);
    }

    private static char toSeparator(boolean unixSeparator) {
        return unixSeparator ? (char)'/' : '\\';
    }

    public static String getPrefix(String fileName) {
        if (fileName == null) {
            return null;
        }
        int len = Filenames.getPrefixLength(fileName);
        if (len < 0) {
            return null;
        }
        if (len > fileName.length()) {
            Filenames.requireNonNullChars(fileName);
            return fileName + '/';
        }
        return Filenames.requireNonNullChars(fileName.substring(0, len));
    }

    private static String requireNonNullChars(String path) {
        if (path.indexOf(0) >= 0) {
            throw new IllegalArgumentException("Null character present in file/path name. There are no known legitimate use cases for such data, but several injection attacks may use it");
        }
        return path;
    }

    private static boolean isSeparator(char ch) {
        return ch == '/' || ch == '\\';
    }

    public static int getPrefixLength(String fileName) {
        if (fileName == null) {
            return -1;
        }
        int len = fileName.length();
        if (len == 0) {
            return 0;
        }
        char ch0 = fileName.charAt(0);
        if (ch0 == ':') {
            return -1;
        }
        if (len == 1) {
            if (ch0 == '~') {
                return 2;
            }
            return Filenames.isSeparator(ch0) ? 1 : 0;
        }
        if (ch0 == '~') {
            int posUnix = fileName.indexOf(47, 1);
            int posWin = fileName.indexOf(92, 1);
            if (posUnix == -1 && posWin == -1) {
                return len + 1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        char ch1 = fileName.charAt(1);
        if (ch1 == ':') {
            if ((ch0 = Character.toUpperCase(ch0)) >= 'A' && ch0 <= 'Z') {
                if (len == 2 && !OsFileSystem.getCurrent().supportsDriveLetter()) {
                    return 0;
                }
                if (len == 2 || !Filenames.isSeparator(fileName.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            if (ch0 == '/') {
                return 1;
            }
            return -1;
        }
        if (!Filenames.isSeparator(ch0) || !Filenames.isSeparator(ch1)) {
            return Filenames.isSeparator(ch0) ? 1 : 0;
        }
        int posUnix = fileName.indexOf(47, 2);
        int posWin = fileName.indexOf(92, 2);
        if (posUnix == -1 && posWin == -1 || posUnix == 2 || posWin == 2) {
            return -1;
        }
        posUnix = posUnix == -1 ? posWin : posUnix;
        posWin = posWin == -1 ? posUnix : posWin;
        int pos = Math.min(posUnix, posWin) + 1;
        String hostnamePart = fileName.substring(2, pos - 1);
        return Nets.isValidHostAddress(hostnamePart) ? pos : -1;
    }

    public static String asUnixFilePath(String filePath) {
        Preconditions.checkNotNull(filePath);
        return filePath.trim().replaceAll("\\\\", FOLDER_SEPARATOR).replaceAll("/+", FOLDER_SEPARATOR);
    }

    public static String getFullDirectory(String filename) {
        return Filenames.doGetFullPath(filename, true);
    }

    public static String getFullPathNoEndSeparator(String filename) {
        return Filenames.doGetFullPath(filename, false);
    }

    private static String doGetFullPath(String filename, boolean includeSeparator) {
        if (filename == null) {
            return null;
        }
        int prefix = Filenames.getPrefixLength(filename);
        if (prefix < 0) {
            return null;
        }
        if (prefix >= filename.length()) {
            if (includeSeparator) {
                return Filenames.getPrefix(filename);
            }
            return filename;
        }
        int index = Filenames.indexOfLastSeparator(filename);
        if (index < 0) {
            return filename.substring(0, prefix);
        }
        int end = index + (includeSeparator ? 1 : 0);
        if (end == 0) {
            ++end;
        }
        return filename.substring(0, end);
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(WINDOWS_FOLDER_SEPARATOR);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static String getFileName(String filename) {
        if (filename == null) {
            return null;
        }
        Filenames.failIfNullBytePresent(filename);
        int index = Filenames.indexOfLastSeparator(filename);
        return filename.substring(index + 1);
    }

    private static void failIfNullBytePresent(String path) {
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            if (path.charAt(i) != '\u0000') continue;
            throw new IllegalArgumentException("Null byte present in file/path name. There are no known legitimate use cases for such data, but several injection attacks may use it");
        }
    }

    public static String getParentPath(String filepath) {
        String filename = Filenames.extractFilename(filepath);
        return filepath.substring(0, filepath.length() - filename.length());
    }

    public static String extractFilename(String filePath) {
        return Filenames.extractFilename(filePath, true);
    }

    public static String extractFilename(String filePath, boolean containsSuffix) {
        Preconditions.checkTrue(Strings.isNotBlank(filePath));
        int lastFileSeparatorIndex = Filenames.asUnixFilePath(filePath).lastIndexOf(FOLDER_SEPARATOR);
        String fileName = filePath.substring(lastFileSeparatorIndex + 1);
        if (containsSuffix) {
            return fileName;
        }
        int suffixIndex = fileName.lastIndexOf(CURRENT_PATH);
        if (suffixIndex > 0 && suffixIndex != fileName.length() - 1) {
            return fileName.substring(0, suffixIndex);
        }
        return fileName;
    }

    public static String getSuffix(String filePath) {
        String filename = Filenames.extractFilename(filePath);
        int index = filename.lastIndexOf(CURRENT_PATH);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String getSuffixAsLowCase(String filename) {
        return Filenames.getSuffix(filename).toLowerCase();
    }

    public static String getSuffixAsUpperCase(String filename) {
        return Filenames.getSuffix(filename).toUpperCase();
    }

    private Filenames() {
    }
}

