/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io.file;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Lists;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.PrimitiveArrays;
import com.jn.langx.util.io.file.Filenames;
import com.jn.langx.util.os.Platform;
import java.util.HashSet;
import java.util.List;

public final class OsFileSystem {
    private final int blockSize;
    private final boolean casePreserving;
    private final boolean caseSensitive;
    private final Character[] illegalFileNameChars;
    private final int maxFileNameLength;
    private final int maxPathLength;
    private final List<String> reservedFileNames;
    private final boolean reservedFileNamesExtensions;
    private final boolean supportsDriveLetter;
    private final char pathSeparator;
    private final char pathSeparatorOther;
    private final String[] pathSeparators;
    public static final OsFileSystem LINUX = new OsFileSystem(8192, true, true, 255, 4096, new Character[]{Character.valueOf('\u0000'), Character.valueOf('/')}, Emptys.EMPTY_STRINGS, false, false, '/');
    public static final OsFileSystem MAC_OSX = new OsFileSystem(4096, true, true, 255, 1024, new Character[]{Character.valueOf('\u0000'), Character.valueOf('/'), Character.valueOf(':')}, Emptys.EMPTY_STRINGS, false, false, '/');
    public static final OsFileSystem WINDOWS = new OsFileSystem(4096, false, true, 255, 32000, new Character[]{Character.valueOf('\u0000'), Character.valueOf('\u0001'), Character.valueOf('\u0002'), Character.valueOf('\u0003'), Character.valueOf('\u0004'), Character.valueOf('\u0005'), Character.valueOf('\u0006'), Character.valueOf('\u0007'), Character.valueOf('\b'), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\u000b'), Character.valueOf('\f'), Character.valueOf('\r'), Character.valueOf('\u000e'), Character.valueOf('\u000f'), Character.valueOf('\u0010'), Character.valueOf('\u0011'), Character.valueOf('\u0012'), Character.valueOf('\u0013'), Character.valueOf('\u0014'), Character.valueOf('\u0015'), Character.valueOf('\u0016'), Character.valueOf('\u0017'), Character.valueOf('\u0018'), Character.valueOf('\u0019'), Character.valueOf('\u001a'), Character.valueOf('\u001b'), Character.valueOf('\u001c'), Character.valueOf('\u001d'), Character.valueOf('\u001e'), Character.valueOf('\u001f'), Character.valueOf('\"'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf(':'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('|')}, new String[]{"AUX", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "CON", "CONIN$", "CONOUT$", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9", "NUL", "PRN"}, true, true, '\\');
    private static final OsFileSystem current = OsFileSystem.current();

    OsFileSystem(int blockSize, boolean caseSensitive, boolean casePreserving, int maxFileLength, int maxPathLength, Character[] illegalFileNameChars, String[] reservedFileNames, boolean reservedFileNamesExtensions, boolean supportsDriveLetter, char pathSeparator) {
        this.blockSize = blockSize;
        this.maxFileNameLength = maxFileLength;
        this.maxPathLength = maxPathLength;
        this.illegalFileNameChars = Objs.requireNonNull(illegalFileNameChars, "illegalFileNameChars");
        this.reservedFileNames = Lists.newArrayList((Object[])Objs.requireNonNull(reservedFileNames, "reservedFileNames"));
        this.reservedFileNamesExtensions = reservedFileNamesExtensions;
        this.caseSensitive = caseSensitive;
        this.casePreserving = casePreserving;
        this.supportsDriveLetter = supportsDriveLetter;
        this.pathSeparator = pathSeparator;
        this.pathSeparatorOther = Filenames.flipSeparator(pathSeparator);
        HashSet<String> pathSeparators = new HashSet<String>();
        pathSeparators.add(this.pathSeparator + "");
        pathSeparators.add("/");
        this.pathSeparators = (String[])Collects.toArray(pathSeparators, String[].class);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public char[] getIllegalFileNameChars() {
        char[] chars = new char[this.illegalFileNameChars.length];
        for (int i = 0; i < this.illegalFileNameChars.length; ++i) {
            chars[i] = this.illegalFileNameChars[i].charValue();
        }
        return chars;
    }

    public char[] getIllegalFileNameCodes() {
        return PrimitiveArrays.unwrap(this.illegalFileNameChars, false);
    }

    public int getMaxFileNameLength() {
        return this.maxFileNameLength;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public char getPathSeparator() {
        return this.pathSeparator;
    }

    public String[] getPathSeparatorStrings() {
        return this.pathSeparators;
    }

    public List<String> getReservedFileNames() {
        return Lists.newArrayList(this.reservedFileNames);
    }

    public boolean isCasePreserving() {
        return this.casePreserving;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isLegalFileName(CharSequence filename) {
        int length = Objs.length(filename);
        if (length < 1 || length > this.maxFileNameLength) {
            return false;
        }
        if (Strings.startsWith(filename, " ") || Strings.startsWith(filename, "\t")) {
            return false;
        }
        if (this.isReservedFileName(filename)) {
            return false;
        }
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (!Collects.contains(this.illegalFileNameChars, Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public boolean isReservedFileName(CharSequence candidate) {
        CharSequence test = this.reservedFileNamesExtensions ? this.trimExtension(candidate) : candidate;
        return this.reservedFileNames.contains(test);
    }

    protected CharSequence trimExtension(CharSequence cs) {
        int index = Strings.lastIndexOf(cs, ".");
        return index < 0 ? cs : cs.subSequence(0, index);
    }

    public boolean supportsDriveLetter() {
        return this.supportsDriveLetter;
    }

    public String normalizeSeparators(String path) {
        return Strings.replaceChars(path, this.pathSeparatorOther, this.pathSeparator);
    }

    private boolean isIllegalFileNameChar(char c) {
        return Pipeline.of(this.illegalFileNameChars).contains(Character.valueOf(c));
    }

    private static OsFileSystem current() {
        if (Platform.isMaxOS) {
            return MAC_OSX;
        }
        if (Platform.isWindows) {
            return WINDOWS;
        }
        return LINUX;
    }

    public static OsFileSystem getCurrent() {
        return current;
    }
}

