/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io.file;

import com.jn.langx.util.io.file.FilePermission;
import java.util.Set;

public class PosixFilePermissions {
    private int permissions;
    private final boolean isOwner;
    private final boolean isInGroup;

    public PosixFilePermissions(int permissions, boolean isOwner, boolean isInGroup) {
        this.permissions = permissions;
        this.isOwner = isOwner;
        this.isInGroup = isInGroup;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public boolean isOwner() {
        return this.isOwner;
    }

    public boolean isInGroup() {
        return this.isInGroup;
    }

    public boolean isExecutable() {
        if (this.isOwner) {
            return FilePermission.USR_X.isIn(this.permissions);
        }
        if (this.isInGroup) {
            return FilePermission.GRP_X.isIn(this.permissions);
        }
        return FilePermission.OTH_X.isIn(this.permissions);
    }

    public boolean isReadable() {
        if (this.isOwner) {
            return FilePermission.USR_R.isIn(this.permissions);
        }
        if (this.isInGroup) {
            return FilePermission.GRP_R.isIn(this.permissions);
        }
        return FilePermission.OTH_R.isIn(this.permissions);
    }

    public boolean isWritable() {
        if (this.isOwner) {
            return FilePermission.USR_W.isIn(this.permissions);
        }
        if (this.isInGroup) {
            return FilePermission.GRP_W.isIn(this.permissions);
        }
        return FilePermission.OTH_W.isIn(this.permissions);
    }

    public void addPermission(FilePermission filePermission) {
        this.permissions |= filePermission.getVal();
    }

    public void removePermission(FilePermission filePermission) {
        this.permissions &= ~filePermission.getVal();
    }

    public Set<FilePermission> getPermissionSet() {
        return FilePermission.fromMask(this.permissions);
    }
}

