/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io.file;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Radixs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.hash.HashCodeBuilder;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.Regexps;

@Deprecated
public class UnixFileAccessMode {
    private static final Regexp PATTERN = Regexps.createRegexp("^[01]+$");
    private static final char TRUE = '1';
    private String binaryMode;

    public UnixFileAccessMode(String binaryMode) {
        this.setBinaryMode(binaryMode);
    }

    public String getBinaryMode() {
        return this.binaryMode;
    }

    public void setBinaryMode(String binaryMode) {
        Preconditions.checkNotEmpty(binaryMode);
        Preconditions.checkArgument(binaryMode.length() >= 9);
        Preconditions.checkArgument(PATTERN.matcher(binaryMode).matches());
        this.binaryMode = binaryMode;
    }

    public boolean isReadable() {
        return this.binaryMode.charAt(0) == '1';
    }

    public boolean isWritable() {
        return this.binaryMode.charAt(1) == '1';
    }

    public boolean isExecutable() {
        return this.binaryMode.charAt(2) == '1';
    }

    public boolean isReadonly() {
        return !this.isWritable() || !this.isExecutable();
    }

    public boolean isGroupReadable() {
        return this.binaryMode.charAt(3) == '1';
    }

    public boolean isGroupWritable() {
        return this.binaryMode.charAt(4) == '1';
    }

    public boolean isGroupExecutable() {
        return this.binaryMode.charAt(5) == '1';
    }

    public boolean isGroupReadonly() {
        return !this.isGroupWritable() || !this.isGroupExecutable();
    }

    public boolean isOtherReadable() {
        return this.binaryMode.charAt(6) == '1';
    }

    public boolean isOtherWritable() {
        return this.binaryMode.charAt(7) == '1';
    }

    public boolean isOtherExecutable() {
        return this.binaryMode.charAt(8) == '1';
    }

    public boolean isOtherReadonly() {
        return !this.isOtherWritable() || !this.isOtherExecutable();
    }

    public boolean isOnlyOwnerExecutable() {
        return this.isExecutable() && !this.isGroupExecutable() && !this.isOtherExecutable();
    }

    public static String toBinaryMode(String octal) {
        Preconditions.checkArgument(Emptys.isNotEmpty(octal));
        Preconditions.checkArgument(octal.length() == 3, "the expected length is 3");
        Preconditions.checkArgument(Radixs.isOctal(octal), "the expect argument is octal string");
        final StringBuilder modeString = new StringBuilder(9);
        Collects.forEach(octal.toCharArray(), new Consumer<Character>(){

            @Override
            public void accept(Character c) {
                modeString.append(Radixs.toBinary(c.charValue() - 48));
            }
        });
        return modeString.toString();
    }

    public static UnixFileAccessMode create(String octal) {
        return new UnixFileAccessMode(UnixFileAccessMode.toBinaryMode(octal));
    }

    public static UnixFileAccessMode create(int decimal) {
        return UnixFileAccessMode.create(Radixs.toOtc(decimal));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnixFileAccessMode that = (UnixFileAccessMode)o;
        return Objs.equals(this.binaryMode, that.binaryMode);
    }

    public int hashCode() {
        return new HashCodeBuilder().with(this.binaryMode).build();
    }

    public String toString() {
        return "binaryMode:" + this.binaryMode + ", octalMode: " + Radixs.binaryToOctal(this.binaryMode);
    }
}

