/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io.file.validator;

import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.io.file.OsFileSystem;
import com.jn.langx.util.io.file.validator.AbstractFilepathValidator;

public class UnixFilepathValidator
extends AbstractFilepathValidator {
    static final UnixFilepathValidator INSTANCE = new UnixFilepathValidator();

    @Override
    public boolean isLegalFilename(String name) {
        return OsFileSystem.LINUX.isLegalFileName(name);
    }

    @Override
    public boolean isLegalFilepath(String path) {
        if (Strings.isEmpty(path)) {
            return false;
        }
        while (Strings.startsWith(path, "/")) {
            path = Strings.substring(path, 1);
        }
        Object[] segments = Strings.split(path, "/", false, false);
        boolean matched = Collects.allMatch(new Predicate<String>(){

            @Override
            public boolean test(String segment) {
                return UnixFilepathValidator.this.isLegalFilename(segment);
            }
        }, segments);
        return matched;
    }
}

