/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io.file.validator;

import com.jn.langx.text.StrTokenizer;
import com.jn.langx.util.Strings;
import com.jn.langx.util.io.file.OsFileSystem;
import com.jn.langx.util.io.file.validator.AbstractFilepathValidator;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.Regexps;

public class WindowsFilepathValidator
extends AbstractFilepathValidator {
    private static final Regexp PARTITION = Regexps.compile("[A-Za-z]((\\w|\\$)+)?");
    static final WindowsFilepathValidator INSTANCE = new WindowsFilepathValidator();

    @Override
    public boolean isLegalFilename(String name) {
        return OsFileSystem.WINDOWS.isLegalFileName(name);
    }

    @Override
    public boolean isLegalFilepath(String path) {
        if (Strings.isEmpty(path)) {
            return false;
        }
        String[] tmp = Strings.split(path, ":", false, false);
        if (tmp.length > 2 || tmp.length < 1) {
            return false;
        }
        String partition = null;
        String pathPart = null;
        if (tmp.length == 2) {
            partition = tmp[0];
            pathPart = tmp[1];
        } else {
            pathPart = tmp[0];
        }
        if (partition != null) {
            while (Strings.startsWith(partition, "/")) {
                partition = Strings.substring(partition, 1);
            }
            if (partition.length() > 32) {
                return false;
            }
            if (!this.isLegalFilename(partition)) {
                return false;
            }
            if (OsFileSystem.WINDOWS.getReservedFileNames().contains(Strings.upperCase(partition))) {
                return false;
            }
            if (!Regexps.match(PARTITION, partition)) {
                return false;
            }
        }
        if (Strings.isEmpty(pathPart)) {
            return false;
        }
        StrTokenizer tokenizer = new StrTokenizer(pathPart, false, OsFileSystem.WINDOWS.getPathSeparatorStrings());
        while (tokenizer.hasNext()) {
            String segment = (String)tokenizer.next();
            if (this.isLegalFilename(segment)) continue;
            return false;
        }
        return true;
    }
}

