/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io.unicode;

public final class Utf16s {
    public static final int CODEPOINT_MIN_VALUE = 0;
    public static final int CODEPOINT_MAX_VALUE = 0x10FFFF;
    public static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    public static final int LEAD_SURROGATE_MIN_VALUE = 55296;
    public static final int TRAIL_SURROGATE_MIN_VALUE = 56320;
    public static final int LEAD_SURROGATE_MAX_VALUE = 56319;
    public static final int TRAIL_SURROGATE_MAX_VALUE = 57343;
    public static final int SURROGATE_MIN_VALUE = 55296;
    private static final int LEAD_SURROGATE_SHIFT_ = 10;
    private static final int TRAIL_SURROGATE_MASK_ = 1023;
    private static final int LEAD_SURROGATE_OFFSET_ = 55232;

    private Utf16s() {
    }

    public static int charAt(String string, int index) {
        int c = string.charAt(index);
        return c < 55296 ? c : Utf16s._charAt(string, index, (char)c);
    }

    private static int _charAt(String string, int index, char c) {
        if (c <= '\udfff') {
            char var3;
            if (c <= '\udbff') {
                char var32;
                if (string.length() != ++index && (var32 = string.charAt(index)) >= '\udc00' && var32 <= '\udfff') {
                    return Utf16s.getRawSupplementary(c, var32);
                }
            } else if (--index >= 0 && (var3 = string.charAt(index)) >= '\ud800' && var3 <= '\udbff') {
                return Utf16s.getRawSupplementary(var3, c);
            }
        }
        return c;
    }

    public static int charAt(char[] chars, int beginIndex, int endIndex, int index) {
        if ((index += beginIndex) >= beginIndex && index < endIndex) {
            char c = chars[index];
            if (Utf16s.isSurrogate(c)) {
                if (c <= '\udbff') {
                    if (++index >= endIndex) {
                        return c;
                    }
                    char c1 = chars[index];
                    if (Utf16s.isTrailSurrogate(c1)) {
                        return Utf16s.getRawSupplementary(c, c1);
                    }
                } else {
                    char c1;
                    if (index == beginIndex) {
                        return c;
                    }
                    if (Utf16s.isLeadSurrogate(c1 = chars[--index])) {
                        return Utf16s.getRawSupplementary(c1, c);
                    }
                }
            }
            return c;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public static int getCharCount(int codepoint) {
        return codepoint < 65536 ? 1 : 2;
    }

    public static boolean isSurrogate(char c) {
        return '\ud800' <= c && c <= '\udfff';
    }

    public static boolean isTrailSurrogate(char c) {
        return '\udc00' <= c && c <= '\udfff';
    }

    public static boolean isLeadSurrogate(char c) {
        return '\ud800' <= c && c <= '\udbff';
    }

    public static char getLeadSurrogate(int c) {
        return c >= 65536 ? (char)(55232 + (c >> 10)) : (char)'\u0000';
    }

    public static char getTrailSurrogate(int c) {
        return c >= 65536 ? (char)(56320 + (c & 0x3FF)) : (char)c;
    }

    public static String valueOf(int c) {
        if (c >= 0 && c <= 0x10FFFF) {
            return Utf16s.toString(c);
        }
        throw new IllegalArgumentException("Illegal codepoint");
    }

    public static StringBuilder append(StringBuilder buffer, int c) {
        if (c >= 0 && c <= 0x10FFFF) {
            if (c >= 65536) {
                buffer.append(Utf16s.getLeadSurrogate(c));
                buffer.append(Utf16s.getTrailSurrogate(c));
            } else {
                buffer.append((char)c);
            }
            return buffer;
        }
        throw new IllegalArgumentException("Illegal codepoint: " + Integer.toHexString(c));
    }

    public static int moveCodePointOffset(char[] chars, int var1, int var2, int var3, int var4) {
        int length = chars.length;
        int index = var3 + var1;
        if (var1 >= 0 && var2 >= var1) {
            if (var2 > length) {
                throw new StringIndexOutOfBoundsException(var2);
            }
            if (var3 >= 0 && index <= var2) {
                int var6;
                if (var4 > 0) {
                    if (var4 + index > length) {
                        throw new StringIndexOutOfBoundsException(index);
                    }
                    for (var6 = var4; index < var2 && var6 > 0; --var6, ++index) {
                        char var7 = chars[index];
                        if (!Utf16s.isLeadSurrogate(var7) || index + 1 >= var2 || !Utf16s.isTrailSurrogate(chars[index + 1])) continue;
                        ++index;
                    }
                } else {
                    if (index + var4 < var1) {
                        throw new StringIndexOutOfBoundsException(index);
                    }
                    for (var6 = -var4; var6 > 0 && --index >= var1; --var6) {
                        char var7 = chars[index];
                        if (!Utf16s.isTrailSurrogate(var7) || index <= var1 || !Utf16s.isLeadSurrogate(chars[index - 1])) continue;
                        --index;
                    }
                }
                if (var6 != 0) {
                    throw new StringIndexOutOfBoundsException(var4);
                }
                return index -= var1;
            }
            throw new StringIndexOutOfBoundsException(var3);
        }
        throw new StringIndexOutOfBoundsException(var1);
    }

    private static String toString(int c) {
        if (c < 65536) {
            return String.valueOf((char)c);
        }
        String buffer = String.valueOf(Utf16s.getLeadSurrogate(c)) + Utf16s.getTrailSurrogate(c);
        return buffer;
    }

    public static int getRawSupplementary(char var0, char var1) {
        return (var0 << 10) + var1 - 56613888;
    }
}

