/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jar;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.ClassLoaders;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Reflects;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;

public class Manifests {
    private Manifests() {
    }

    public static Manifest loadManifest() {
        URL url = Reflects.getCodeLocation(Manifests.class);
        if (url != null) {
            if (url.getPath().endsWith("target/classes/")) {
                return null;
            }
            String jarPath = url.getPath();
            if (jarPath.startsWith("file:")) {
                jarPath = jarPath.replaceFirst("file:", "");
            }
            return Manifests.loadManifest(jarPath);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest loadManifest(@Nullable String jarPath) {
        Manifest manifest;
        if (jarPath == null) {
            return null;
        }
        String path0 = jarPath;
        String[] pathSegments = jarPath.split("!/");
        if (!Emptys.isEmpty(pathSegments)) {
            for (String segment : pathSegments) {
                if (Emptys.isEmpty(segment)) continue;
                jarPath = segment;
                break;
            }
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarPath);
            manifest = jarFile.getManifest();
        }
        catch (Throwable ex) {
            Manifest manifest2;
            try {
                Logger logger = Loggers.getLogger(Manifests.class);
                logger.warn("Can't find the jar : {}", (Object)path0);
                manifest2 = null;
            }
            catch (Throwable throwable) {
                IOs.close(jarFile);
                throw throwable;
            }
            IOs.close(jarFile);
            return manifest2;
        }
        IOs.close(jarFile);
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest(Class<?> klass) {
        JarFile jarFile = null;
        try {
            jarFile = ClassLoaders.getJarFile(klass);
            if (jarFile != null) {
                Manifest manifest = jarFile.getManifest();
                return manifest;
            }
        }
        catch (Throwable ex) {
            Logger logger = Loggers.getLogger(Manifests.class);
            logger.warn("Can't find the jar for class: {}", (Object)Reflects.getFQNClassName(klass));
        }
        finally {
            IOs.close(jarFile);
        }
        return null;
    }

    public static String getClassVersion(Class<?> klass) {
        Package p = klass.getPackage();
        if (p != null) {
            return p.getImplementationVersion();
        }
        Manifest manifest = Manifests.getManifest(klass);
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        String version = attributes.getValue("Implementation-Version");
        if (Emptys.isNotEmpty(version)) {
            return version;
        }
        try {
            Object module = klass.getClass().getMethod("getModule", new Class[0]).invoke(klass, new Object[0]);
            Object descriptor = module.getClass().getMethod("getDescriptor", new Class[0]).invoke(module, new Object[0]);
            return (String)descriptor.getClass().getMethod("rawVersion", new Class[0]).invoke(descriptor, new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

