/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.memory.leak;

import com.jn.langx.text.properties.PropertiesAccessor;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.SystemPropertys;
import com.jn.langx.util.concurrent.threadlocal.GlobalThreadLocalMap;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.memory.leak.ResourceLeakHint;
import com.jn.langx.util.memory.leak.ResourceLeakTracker;
import com.jn.langx.util.reflect.Reflects;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;

public class ResourceLeakDetector<T> {
    private static String RESOURCE_LEAK_DETECTION_PREFIX;
    private static final String PROP_LEVEL;
    private static final Level DEFAULT_LEVEL;
    private static final String PROP_TARGET_RECORDS;
    private static final int DEFAULT_TARGET_RECORDS = 4;
    private static final String PROP_SAMPLING_INTERVAL;
    private static final int DEFAULT_SAMPLING_INTERVAL = 128;
    private static final int TARGET_RECORDS;
    static final int SAMPLING_INTERVAL;
    private static Level level;
    private final Set<DefaultResourceLeak> allLeaks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final ConcurrentMap<String, Boolean> reportedLeaks = new ConcurrentHashMap<String, Boolean>();
    private final String resourceType;
    private final int samplingInterval;
    private static final AtomicReference<String[]> excludedMethods;

    public static boolean isEnabled() {
        return ResourceLeakDetector.getLevel().ordinal() > Level.DISABLED.ordinal();
    }

    public static void setLevel(Level level) {
        Preconditions.checkNotNull(level);
        ResourceLeakDetector.level = level;
    }

    public static Level getLevel() {
        return level;
    }

    public ResourceLeakDetector(Class<?> resourceType, int samplingInterval) {
        this.resourceType = Reflects.getSimpleClassName(resourceType);
        this.samplingInterval = samplingInterval;
    }

    public final ResourceLeakTracker<T> track(T obj) {
        return this.track0(obj);
    }

    private DefaultResourceLeak track0(T obj) {
        Level level = ResourceLeakDetector.level;
        if (level == Level.DISABLED) {
            return null;
        }
        if (level.ordinal() < Level.PARANOID.ordinal()) {
            if (GlobalThreadLocalMap.getRandom().nextInt(this.samplingInterval) == 0) {
                this.reportLeak();
                return new DefaultResourceLeak(obj, this.refQueue, this.allLeaks);
            }
            return null;
        }
        this.reportLeak();
        return new DefaultResourceLeak(obj, this.refQueue, this.allLeaks);
    }

    private void clearRefQueue() {
        DefaultResourceLeak ref;
        while ((ref = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            ref.dispose();
        }
    }

    private void reportLeak() {
        DefaultResourceLeak ref;
        Logger logger = Loggers.getLogger(this.getClass());
        if (!logger.isErrorEnabled()) {
            this.clearRefQueue();
            return;
        }
        while ((ref = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            String records;
            if (!ref.dispose() || this.reportedLeaks.putIfAbsent(records = ref.toString(), Boolean.TRUE) != null) continue;
            if (records.isEmpty()) {
                this.reportUntracedLeak(this.resourceType);
                continue;
            }
            this.reportTracedLeak(this.resourceType, records);
        }
    }

    protected void reportTracedLeak(String resourceType, String records) {
        Logger logger = Loggers.getLogger(this.getClass());
        logger.error("LEAK: {} was not (close | stop | release | dispose, or other similar method) before it's garbage-collected. See https://netty.io/wiki/reference-counted-objects.html for more information.{}", (Object)resourceType, (Object)records);
    }

    protected void reportUntracedLeak(String resourceType) {
        Logger logger = Loggers.getLogger(this.getClass());
        logger.error("LEAK: {} was not (close | stop | release | dispose, or other similar method) before it's garbage-collected. Enable advanced leak reporting to find out where the leak occurred. To enable advanced leak reporting, specify the JVM option '-D{}={}' or call {}.setLevel() See https://netty.io/wiki/reference-counted-objects.html for more information.", new Object[]{resourceType, PROP_LEVEL, Level.ADVANCED.name().toLowerCase(), Reflects.getSimpleClassName(this)});
    }

    public static void addExclusions(Class clz, String ... methodNames) {
        String[] newMethods;
        String[] oldMethods;
        Method method;
        HashSet<String> nameSet = new HashSet<String>(Arrays.asList(methodNames));
        Iterator<Method> iterator = Reflects.getAllDeclaredMethods(clz, false).iterator();
        while (!(!iterator.hasNext() || nameSet.remove((method = iterator.next()).getName()) && nameSet.isEmpty())) {
        }
        if (!nameSet.isEmpty()) {
            throw new IllegalArgumentException("Can't find '" + nameSet + "' in " + clz.getName());
        }
        do {
            oldMethods = excludedMethods.get();
            newMethods = Arrays.copyOf(oldMethods, oldMethods.length + 2 * methodNames.length);
            for (int i = 0; i < methodNames.length; ++i) {
                newMethods[oldMethods.length + i * 2] = clz.getName();
                newMethods[oldMethods.length + i * 2 + 1] = methodNames[i];
            }
        } while (!excludedMethods.compareAndSet(oldMethods, newMethods));
    }

    static {
        boolean disabled;
        String enabledSwitch;
        RESOURCE_LEAK_DETECTION_PREFIX = SystemPropertys.getAccessor().getString("RESOURCE_LEAK_DETECTION_PREFIX", "langx.leakDetection");
        PROP_LEVEL = RESOURCE_LEAK_DETECTION_PREFIX + ".level";
        DEFAULT_LEVEL = Level.SIMPLE;
        PROP_TARGET_RECORDS = RESOURCE_LEAK_DETECTION_PREFIX + ".targetRecords";
        PROP_SAMPLING_INTERVAL = RESOURCE_LEAK_DETECTION_PREFIX + ".samplingInterval";
        PropertiesAccessor systemPropertiesAccessor = SystemPropertys.getAccessor();
        if (systemPropertiesAccessor.get(enabledSwitch = RESOURCE_LEAK_DETECTION_PREFIX + ".enabled") != null) {
            disabled = systemPropertiesAccessor.getBoolean(enabledSwitch, false);
            Logger logger = Loggers.getLogger(ResourceLeakDetector.class);
            logger.debug("-{}: {}", (Object)enabledSwitch, (Object)disabled);
        } else {
            disabled = false;
        }
        Level defaultLevel = disabled ? Level.DISABLED : DEFAULT_LEVEL;
        String levelStr = systemPropertiesAccessor.getString(PROP_LEVEL, defaultLevel.name());
        Level level = Level.parseLevel(levelStr);
        TARGET_RECORDS = systemPropertiesAccessor.getInteger(PROP_TARGET_RECORDS, 4);
        SAMPLING_INTERVAL = systemPropertiesAccessor.getInteger(PROP_SAMPLING_INTERVAL, 128);
        ResourceLeakDetector.level = level;
        Logger logger = Loggers.getLogger(ResourceLeakDetector.class);
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_LEVEL, (Object)level.name().toLowerCase());
            logger.debug("-D{}: {}", (Object)PROP_TARGET_RECORDS, (Object)TARGET_RECORDS);
        }
        excludedMethods = new AtomicReference<String[]>(Emptys.EMPTY_STRINGS);
    }

    private static final class Record
    extends Throwable {
        private static final long serialVersionUID = 6065153674892850720L;
        private static final Record BOTTOM = new Record();
        private final String hintString;
        private final Record next;
        private final int pos;

        Record(Record next, Object hint) {
            this.hintString = hint instanceof ResourceLeakHint ? ((ResourceLeakHint)hint).toHintString() : hint.toString();
            this.next = next;
            this.pos = next.pos + 1;
        }

        Record(Record next) {
            this.hintString = null;
            this.next = next;
            this.pos = next.pos + 1;
        }

        private Record() {
            this.hintString = null;
            this.next = null;
            this.pos = -1;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(2048);
            if (this.hintString != null) {
                buf.append("\tHint: ").append(this.hintString).append(SystemPropertys.NEWLINE);
            }
            StackTraceElement[] array = this.getStackTrace();
            block0: for (int i = 3; i < array.length; ++i) {
                StackTraceElement element = array[i];
                String[] exclusions = (String[])excludedMethods.get();
                for (int k = 0; k < exclusions.length; k += 2) {
                    if (exclusions[k].equals(element.getClassName()) && exclusions[k + 1].equals(element.getMethodName())) continue block0;
                }
                buf.append('\t');
                buf.append(element.toString());
                buf.append(SystemPropertys.NEWLINE);
            }
            return buf.toString();
        }
    }

    private static final class DefaultResourceLeak<T>
    extends WeakReference<Object>
    implements ResourceLeakTracker<T> {
        private static final AtomicReferenceFieldUpdater<DefaultResourceLeak, Record> headUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultResourceLeak.class, Record.class, "head");
        private static final AtomicIntegerFieldUpdater<DefaultResourceLeak> droppedRecordsUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultResourceLeak.class, "droppedRecords");
        private volatile Record head;
        private volatile int droppedRecords;
        private final Set<DefaultResourceLeak> allLeaks;
        private final int trackedHash;

        DefaultResourceLeak(Object referent, ReferenceQueue<Object> refQueue, Set<DefaultResourceLeak> allLeaks) {
            super(referent, refQueue);
            assert (referent != null);
            this.trackedHash = Objs.id(referent);
            Preconditions.checkNotNull(allLeaks);
            allLeaks.add(this);
            headUpdater.set(this, new Record(Record.BOTTOM));
            this.allLeaks = allLeaks;
        }

        @Override
        public void record() {
            this.record0(null);
        }

        @Override
        public void record(Object hint) {
            this.record0(hint);
        }

        private void record0(Object hint) {
            if (TARGET_RECORDS > 0) {
                boolean dropped;
                Record prevHead;
                Record newHead;
                Record oldHead;
                do {
                    prevHead = oldHead = headUpdater.get(this);
                    if (oldHead == null) {
                        return;
                    }
                    int numElements = oldHead.pos + 1;
                    if (numElements >= TARGET_RECORDS) {
                        int backOffFactor = Math.min(numElements - TARGET_RECORDS, 30);
                        boolean bl = dropped = GlobalThreadLocalMap.getRandom().nextInt(1 << backOffFactor) != 0;
                        if (!dropped) continue;
                        prevHead = oldHead.next;
                        continue;
                    }
                    dropped = false;
                } while (!headUpdater.compareAndSet(this, oldHead, newHead = hint != null ? new Record(prevHead, hint) : new Record(prevHead)));
                if (dropped) {
                    droppedRecordsUpdater.incrementAndGet(this);
                }
            }
        }

        boolean dispose() {
            this.clear();
            return this.allLeaks.remove(this);
        }

        public boolean close() {
            if (this.allLeaks.remove(this)) {
                this.clear();
                headUpdater.set(this, null);
                return true;
            }
            return false;
        }

        @Override
        public boolean close(T trackedObject) {
            assert (this.trackedHash == Objs.id(trackedObject));
            try {
                boolean bl = this.close();
                return bl;
            }
            finally {
                DefaultResourceLeak.reachabilityFence0(trackedObject);
            }
        }

        private static void reachabilityFence0(Object ref) {
            if (ref != null) {
                // empty if block
            }
        }

        public String toString() {
            Record oldHead = headUpdater.getAndSet(this, null);
            if (oldHead == null) {
                return "";
            }
            int dropped = droppedRecordsUpdater.get(this);
            int duped = 0;
            int present = oldHead.pos + 1;
            StringBuilder buf = new StringBuilder(present * 2048).append(SystemPropertys.NEWLINE);
            buf.append("Recent access records: ").append(SystemPropertys.NEWLINE);
            int i = 1;
            HashSet<String> seen = new HashSet<String>(present);
            while (oldHead != Record.BOTTOM) {
                String s = oldHead.toString();
                if (seen.add(s)) {
                    if (oldHead.next == Record.BOTTOM) {
                        buf.append("Created at:").append(SystemPropertys.NEWLINE).append(s);
                    } else {
                        buf.append('#').append(i++).append(':').append(SystemPropertys.NEWLINE).append(s);
                    }
                } else {
                    ++duped;
                }
                oldHead = oldHead.next;
            }
            if (duped > 0) {
                buf.append(": ").append(duped).append(" leak records were discarded because they were duplicates").append(SystemPropertys.NEWLINE);
            }
            if (dropped > 0) {
                buf.append(": ").append(dropped).append(" leak records were discarded because the leak record count is targeted to ").append(TARGET_RECORDS).append(". Use system property ").append(PROP_TARGET_RECORDS).append(" to increase the limit.").append(SystemPropertys.NEWLINE);
            }
            buf.setLength(buf.length() - SystemPropertys.NEWLINE.length());
            return buf.toString();
        }
    }

    public static enum Level {
        DISABLED,
        SIMPLE,
        ADVANCED,
        PARANOID;


        static Level parseLevel(String levelStr) {
            String trimmedLevelStr = levelStr.trim();
            for (Level l : Level.values()) {
                if (!trimmedLevelStr.equalsIgnoreCase(l.name()) && !trimmedLevelStr.equals(String.valueOf(l.ordinal()))) continue;
                return l;
            }
            return DEFAULT_LEVEL;
        }
    }
}

