/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.memory.objectsize;

import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.ClassLoaders;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.ConcurrentReferenceHashMap;
import com.jn.langx.util.collection.IdentityHashSet;
import com.jn.langx.util.collection.Maps;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.memory.objectsize.Arch32MemoryLayoutSpecification;
import com.jn.langx.util.memory.objectsize.Arch64CompressedMemoryLayoutSpecified;
import com.jn.langx.util.memory.objectsize.Arch64UncompressedMemoryLayoutSpecification;
import com.jn.langx.util.memory.objectsize.MemoryLayoutSpecification;
import com.jn.langx.util.memory.objectsize.ObjectSizeEstimator;
import com.jn.langx.util.os.JVMCore;
import com.jn.langx.util.os.Platform;
import com.jn.langx.util.reflect.Modifiers;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.reference.ReferenceType;
import com.jn.langx.util.reflect.type.Primitives;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;

public class ObjectSizeCalculator {
    private static final ConcurrentReferenceHashMap<Class<?>, ClassSizeInfo> classSizeInfos = new ConcurrentReferenceHashMap(100, ReferenceType.WEAK, ReferenceType.STRONG);
    private final Set<Object> alreadyVisited = new IdentityHashSet<Object>();
    private final Deque<Object> pending = new ArrayDeque<Object>(16384);
    private long size;
    private MemoryLayoutSpecification memoryLayout;

    public static long getObjectSize(Object obj) {
        return ObjectSizeCalculator.getObjectSize(obj, false);
    }

    public static long getObjectSize(Object obj, boolean estimateMode) {
        if (obj == null) {
            return 0L;
        }
        try {
            if (estimateMode) {
                return ObjectSizeEstimator.estimate(obj);
            }
            return new ObjectSizeCalculator(CurrentLayout.SPEC).calculateObjectSize(obj);
        }
        catch (Throwable e) {
            throw Throwables.wrapAsRuntimeException(e);
        }
    }

    public ObjectSizeCalculator(MemoryLayoutSpecification memoryLayoutSpecification) {
        Preconditions.checkNotNull(memoryLayoutSpecification);
        this.memoryLayout = memoryLayoutSpecification;
    }

    private synchronized long calculateObjectSize(Object obj) {
        try {
            while (true) {
                this.visit(obj);
                if (this.pending.isEmpty()) {
                    long l = this.size;
                    return l;
                }
                obj = this.pending.removeFirst();
            }
        }
        finally {
            this.alreadyVisited.clear();
            this.pending.clear();
            this.size = 0L;
        }
    }

    private void visit(Object obj) {
        if (this.alreadyVisited.contains(obj)) {
            return;
        }
        Class<?> clazz = obj.getClass();
        if (clazz == ArrayElementsVisitor.class) {
            ((ArrayElementsVisitor)obj).visit(this);
        } else {
            this.alreadyVisited.add(obj);
            if (clazz.isArray()) {
                this.visitArray(obj);
            } else {
                Maps.putIfAbsent(classSizeInfos, clazz, new Supplier<Class<?>, ClassSizeInfo>(){

                    @Override
                    public ClassSizeInfo get(Class<?> clazz) {
                        return new ClassSizeInfo(clazz);
                    }
                }).visit(obj, this);
            }
        }
    }

    private void visitArray(Object array) {
        Class<?> componentType = array.getClass().getComponentType();
        int length = Array.getLength(array);
        if (componentType.isPrimitive()) {
            this.increaseByArraySize(length, Primitives.sizeOf(componentType));
        } else {
            this.increaseByArraySize(length, this.memoryLayout.getReferenceSize());
            switch (length) {
                case 0: {
                    break;
                }
                case 1: {
                    this.enqueue(Array.get(array, 0));
                    break;
                }
                default: {
                    this.enqueue(new ArrayElementsVisitor((Object[])array));
                }
            }
        }
    }

    private void increaseByArraySize(int length, long elementSize) {
        this.increaseSize(ObjectSizeCalculator.roundTo((long)this.memoryLayout.getArrayHeaderSize() + (long)length * elementSize, this.memoryLayout.getObjectPadding()));
    }

    void enqueue(Object obj) {
        if (obj != null) {
            this.pending.addLast(obj);
        }
    }

    void increaseSize(long objectSize) {
        this.size += objectSize;
    }

    static long roundTo(long x, int multiple) {
        return (x + (long)multiple - 1L) / (long)multiple * (long)multiple;
    }

    static MemoryLayoutSpecification getEffectiveMemoryLayoutSpecification() {
        if (Platform.JVM != JVMCore.OPEN_J9 && Platform.JVM != JVMCore.HOTSPOT) {
            throw new UnsupportedOperationException(StringTemplates.formatWithPlaceholder("unsupported jvm: {}", Platform.JVM.getName()));
        }
        if (Platform.JVM_BITs == 32) {
            return new Arch32MemoryLayoutSpecification();
        }
        if (Platform.JVM_BITs != 64) {
            throw new UnsupportedOperationException("Unrecognized value '" + Platform.JVM_BITs + "' of sun.arch.data.model system property");
        }
        boolean isCompressedOops = true;
        switch (Platform.JVM) {
            case OPEN_J9: {
                isCompressedOops = Strings.contains(System.getProperty("java.vm.info"), "Compressed Ref");
                break;
            }
            case HOTSPOT: {
                try {
                    String hotSpotMBeanName = "com.sun.management:type=HotSpotDiagnostic";
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    Object bean = ManagementFactory.newPlatformMXBeanProxy(server, hotSpotMBeanName, ClassLoaders.loadClass("com.sun.management.HotSpotDiagnosticMXBean"));
                    Object optionValue = Reflects.invokeDeclaredMethod(bean, "getVMOption", new Class[]{String.class}, new Object[]{"UseCompressedOops"}, true, true);
                    isCompressedOops = Strings.contains(optionValue.toString(), "true");
                }
                catch (Exception e) {
                    boolean guess = Runtime.getRuntime().maxMemory() < 0x800000000L;
                    Loggers.getLogger(ObjectSizeCalculator.class).warn("Failed to check whether UseCompressedOops is set; assuming {}", (Object)(guess ? "yes" : "not"));
                    isCompressedOops = guess;
                }
                break;
            }
            default: {
                boolean guess = Runtime.getRuntime().maxMemory() < 0x800000000L;
                Loggers.getLogger(ObjectSizeCalculator.class).warn("Failed to check whether UseCompressedOops is set; assuming {}", (Object)(guess ? "yes" : "not"));
                isCompressedOops = guess;
                break;
            }
        }
        return isCompressedOops ? new Arch64CompressedMemoryLayoutSpecified() : new Arch64UncompressedMemoryLayoutSpecification();
    }

    static void addReferenceFiled(Class caller, List<Field> referenceFields, Field f) {
        try {
            Reflects.makeAccessible(f);
            referenceFields.add(f);
        }
        catch (SecurityException securityException) {
        }
        catch (RuntimeException re) {
            String fieldName = f.getName();
            Class<?> clazz = f.getDeclaringClass();
            if (Objs.equals(re.getClass().getSimpleName(), "InaccessibleObjectException")) {
                if (Platform.is9VMOrGreater()) {
                    Loggers.getLogger(caller).error("error when analyze filed {} in class {}, error message: {}", new Object[]{fieldName, Reflects.getFQNClassName(clazz), re.getMessage()});
                }
            }
            Loggers.getLogger(caller).warn("analyze field {} in class {} failed, error message: {}", new Object[]{fieldName, Reflects.getFQNClassName(clazz), re.getMessage()});
        }
    }

    private class ClassSizeInfo {
        private final long objectSize;
        private final long fieldsSize;
        private final Field[] referenceFields;

        public ClassSizeInfo(Class<?> clazz) {
            long fieldsSize = 0L;
            LinkedList<Field> referenceFields = new LinkedList<Field>();
            for (Field f : Reflects.getAllDeclaredFields(clazz)) {
                if (Modifiers.isStatic(f)) continue;
                Class<?> type = f.getType();
                if (type.isPrimitive()) {
                    fieldsSize += (long)Primitives.sizeOf(type);
                    continue;
                }
                ObjectSizeCalculator.addReferenceFiled(ObjectSizeCalculator.class, referenceFields, f);
                fieldsSize += (long)ObjectSizeCalculator.this.memoryLayout.getReferenceSize();
            }
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                ClassSizeInfo superClassInfo = (ClassSizeInfo)Maps.putIfAbsent(classSizeInfos, superClass, new Supplier<Class<?>, ClassSizeInfo>(){

                    @Override
                    public ClassSizeInfo get(Class<?> clazz) {
                        return new ClassSizeInfo(clazz);
                    }
                });
                fieldsSize += ObjectSizeCalculator.roundTo(superClassInfo.fieldsSize, ObjectSizeCalculator.this.memoryLayout.getSuperclassFieldPadding());
                referenceFields.addAll(Arrays.asList(superClassInfo.referenceFields));
            }
            this.fieldsSize = fieldsSize;
            this.objectSize = ObjectSizeCalculator.roundTo((long)ObjectSizeCalculator.this.memoryLayout.getObjectHeaderSize() + fieldsSize, ObjectSizeCalculator.this.memoryLayout.getObjectPadding());
            this.referenceFields = referenceFields.toArray(new Field[0]);
        }

        void visit(Object obj, ObjectSizeCalculator calc) {
            calc.increaseSize(this.objectSize);
            this.enqueueReferencedObjects(obj, calc);
        }

        public void enqueueReferencedObjects(Object obj, ObjectSizeCalculator calc) {
            for (Field f : this.referenceFields) {
                try {
                    calc.enqueue(Reflects.getFieldValue(f, obj, true, true));
                }
                catch (Throwable e) {
                    AssertionError ae = new AssertionError((Object)("Unexpected denial of access to " + f));
                    throw ae;
                }
            }
        }
    }

    private class ArrayElementsVisitor {
        private final Object[] array;

        ArrayElementsVisitor(Object[] array) {
            this.array = array;
        }

        public void visit(ObjectSizeCalculator calc) {
            for (Object elem : this.array) {
                if (elem == null) continue;
                calc.visit(elem);
            }
        }
    }

    static class CurrentLayout {
        static final MemoryLayoutSpecification SPEC = ObjectSizeCalculator.getEffectiveMemoryLayoutSpecification();

        CurrentLayout() {
        }
    }
}

