/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.memory.objectsize;

import com.jn.langx.util.Maths;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.ConcurrentReferenceHashMap;
import com.jn.langx.util.collection.Lists;
import com.jn.langx.util.collection.OpenHashSet;
import com.jn.langx.util.concurrent.threadlocal.GlobalThreadLocalMap;
import com.jn.langx.util.memory.objectsize.MemoryLayoutSpecification;
import com.jn.langx.util.memory.objectsize.ObjectSizeCalculator;
import com.jn.langx.util.random.IRandom;
import com.jn.langx.util.reflect.Modifiers;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.reference.ReferenceType;
import com.jn.langx.util.reflect.type.Primitives;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Stack;

class ObjectSizeEstimator {
    private static final int ARRAY_SIZE_FOR_SAMPLING = 400;
    private static final int ARRAY_SAMPLE_SIZE = 100;
    private static final int[] fieldSizes = new int[]{8, 4, 2, 1};
    private static final ConcurrentReferenceHashMap<Class, ClassInfo> classInfos = new ConcurrentReferenceHashMap(100, ReferenceType.WEAK, ReferenceType.SOFT);
    private static MemoryLayoutSpecification memoryLayout;

    private ObjectSizeEstimator() {
    }

    public static long estimate(Object obj) {
        return ObjectSizeEstimator.estimate(obj, new IdentityHashMap());
    }

    private static void initialize() {
        memoryLayout = ObjectSizeCalculator.CurrentLayout.SPEC;
        classInfos.clear();
        classInfos.put(Object.class, new ClassInfo(memoryLayout.getObjectHeaderSize(), Collects.<Field>immutableList()));
    }

    private static long estimate(Object obj, IdentityHashMap visited) {
        SearchState state = new SearchState(visited);
        state.enqueue(obj);
        while (!state.isFinished()) {
            ObjectSizeEstimator.visitSingleObject(state.dequeue(), state);
        }
        return state.size;
    }

    private static void visitSingleObject(Object obj, SearchState state) throws RuntimeException {
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            ObjectSizeEstimator.visitArray(obj, cls, state);
        } else if (!(cls.getName().startsWith("scala.reflect") || obj instanceof ClassLoader || obj instanceof Class)) {
            ClassInfo classInfo = ObjectSizeEstimator.getClassInfo(cls);
            SearchState searchState = state;
            searchState.size = searchState.size + ObjectSizeEstimator.alignSize(classInfo.shellSize);
            for (Field field : classInfo.pointerFields) {
                try {
                    state.enqueue(Reflects.getFieldValue(field, obj, true, true));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static ClassInfo getClassInfo(Class cls) {
        ClassInfo info = classInfos.get(cls);
        if (info != null) {
            return info;
        }
        ClassInfo parent = ObjectSizeEstimator.getClassInfo(cls.getSuperclass());
        long shellSize = parent.shellSize;
        ArrayList<Field> pointerFields = Lists.newArrayList(parent.pointerFields);
        int[] sizeCount = new int[Maths.max(fieldSizes) + 1];
        for (Field field : cls.getDeclaredFields()) {
            if (Modifiers.isStatic(field)) continue;
            Class<?> fieldClass = field.getType();
            if (fieldClass.isPrimitive()) {
                int size = Primitives.sizeOf(fieldClass);
                sizeCount[size] = sizeCount[size] + 1;
                continue;
            }
            ObjectSizeCalculator.addReferenceFiled(ObjectSizeEstimator.class, pointerFields, field);
            sizeCount[ObjectSizeEstimator.memoryLayout.getReferenceSize()] = sizeCount[memoryLayout.getReferenceSize()] + 1;
        }
        long alignedSize = shellSize;
        for (int size : fieldSizes) {
            if (sizeCount[size] <= 0) continue;
            long count = sizeCount[size];
            alignedSize = Maths.maxLong(alignedSize, ObjectSizeEstimator.alignSizeUp(shellSize, size) + (long)size * count);
            shellSize += (long)size * count;
        }
        shellSize = ObjectSizeEstimator.alignSizeUp(alignedSize, memoryLayout.getReferenceSize());
        ClassInfo newInfo = new ClassInfo(shellSize, pointerFields);
        classInfos.put(cls, newInfo);
        return newInfo;
    }

    private static long alignSize(long size) {
        return ObjectSizeEstimator.alignSizeUp(size, memoryLayout.getObjectPadding());
    }

    private static long alignSizeUp(long size, int alignSize) {
        return size + (long)alignSize - 1L & (long)(~(alignSize - 1));
    }

    private static void visitArray(Object array, Class arrayClass, SearchState state) {
        int length = Array.getLength(array);
        Class<?> elementClass = arrayClass.getComponentType();
        long arrSize = ObjectSizeEstimator.alignSize(memoryLayout.getObjectHeaderSize() + Primitives.sizeOf(Integer.TYPE));
        if (elementClass.isPrimitive()) {
            SearchState searchState = state;
            searchState.size = searchState.size + (arrSize += ObjectSizeEstimator.alignSize((long)length * (long)Primitives.sizeOf(elementClass)));
        } else {
            SearchState searchState = state;
            searchState.size = searchState.size + (arrSize += ObjectSizeEstimator.alignSize((long)length * (long)ObjectSizeEstimator.memoryLayout.getReferenceSize()));
            if (length <= 400) {
                for (int arrayIndex = 0; arrayIndex < length; ++arrayIndex) {
                    state.enqueue(ObjectSizeEstimator.getArrayElementByIndex(array, arrayIndex));
                }
            } else {
                IRandom rand = GlobalThreadLocalMap.getRandom();
                OpenHashSet<Integer> drawn = new OpenHashSet<Integer>(200, Integer.class);
                long s1 = ObjectSizeEstimator.sampleArray(array, state, rand, drawn, length);
                long s2 = ObjectSizeEstimator.sampleArray(array, state, rand, drawn, length);
                long size = Math.min(s1, s2);
                SearchState searchState2 = state;
                searchState2.size = searchState2.size + (Math.max(s1, s2) + size * (long)((length - 100) / 100));
            }
        }
    }

    private static long sampleArray(Object array, SearchState state, IRandom rand, OpenHashSet<Integer> drawn, int length) {
        long size = 0L;
        for (int i = 0; i < 100; ++i) {
            int index = 0;
            while (drawn.contains(index = rand.nextInt(length))) {
            }
            drawn.add(index);
            Object obj = ObjectSizeEstimator.getArrayElementByIndex(array, index);
            if (obj == null) continue;
            size += ObjectSizeEstimator.estimate(obj, state.visited);
        }
        return size;
    }

    private static Object getArrayElementByIndex(Object xs, int idx) {
        if (xs == null) {
            throw new NullPointerException();
        }
        if (!xs.getClass().isArray()) {
            throw new IllegalArgumentException("not a array");
        }
        return Array.get(xs, idx);
    }

    static {
        ObjectSizeEstimator.initialize();
    }

    static class SearchState {
        private final IdentityHashMap<Object, Object> visited;
        private final Stack<Object> stack;
        private long size;

        public IdentityHashMap<Object, Object> visited() {
            return this.visited;
        }

        public Stack<Object> stack() {
            return this.stack;
        }

        public long size() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public void enqueue(Object obj) {
            if (obj != null && !this.visited().containsKey(obj)) {
                this.visited().put(obj, null);
                this.stack().push(obj);
            }
        }

        public boolean isFinished() {
            return this.stack().isEmpty();
        }

        public Object dequeue() {
            if (!this.stack.isEmpty()) {
                return this.stack.pop();
            }
            return null;
        }

        public SearchState(IdentityHashMap<Object, Object> visited) {
            this.visited = visited;
            this.stack = new Stack();
            this.size = 0L;
        }
    }

    private static class ClassInfo {
        final long shellSize;
        final List<Field> pointerFields;

        public ClassInfo(long shellSize, List<Field> pointerFields) {
            this.shellSize = shellSize;
            this.pointerFields = pointerFields;
        }
    }
}

