/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.net;

import com.jn.langx.Parser;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Numbers;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Lists;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.net.NetworkAddress;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.RegexpPatterns;
import com.jn.langx.util.regexp.Regexps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class ClusterAddressParser
implements Parser<String, List<NetworkAddress>> {
    private static final Regexp IP_PORT_SEGMENT_PATTERN = Regexps.createRegexp("(?<ip>[^/]*)((/(?<prefixLength>\\d{1,6}))?(:(?<port>\\d{1,5}))?)?");
    private static final Regexp IPv4_PORT_SEGMENT_PATTERN = Regexps.createRegexp("(?<ip>[^:]*)(:(?<port>\\d{1,5}))?");
    private int defaultPort = -1;
    private boolean supportsPortAtEnd = false;

    public ClusterAddressParser() {
    }

    public ClusterAddressParser(int defaultPort) {
        this(defaultPort, false);
    }

    public ClusterAddressParser(int defaultPort, boolean supportsPortAtEnd) {
        this.setDefaultPort(defaultPort);
        this.setSupportsPortAtEnd(supportsPortAtEnd);
    }

    public void setSupportsPortAtEnd(boolean supportsPortAtEnd) {
        this.supportsPortAtEnd = supportsPortAtEnd;
    }

    public static String normalize(List<NetworkAddress> addresses, final ClusterAddressStyle style) {
        Preconditions.checkNotEmpty(addresses);
        final StringBuilder builder = new StringBuilder(256);
        Collects.forEach(addresses, new Consumer2<Integer, NetworkAddress>(){

            @Override
            public void accept(Integer index, NetworkAddress address) {
                if (index > 0) {
                    builder.append(",");
                }
                if (style == ClusterAddressStyle.HOST_PORT_PAIR) {
                    builder.append(address.getHost()).append(":").append(address.getPort());
                } else if (style == ClusterAddressStyle.PORT_AT_END) {
                    builder.append(address.getHost());
                }
            }
        });
        if (style == ClusterAddressStyle.PORT_AT_END) {
            builder.append(":").append(addresses.get(addresses.size() - 1).getPort());
        }
        return builder.toString();
    }

    @Override
    public List<NetworkAddress> parse(String s) {
        if (Strings.isBlank(s)) {
            return Collections.emptyList();
        }
        ArrayList<NetworkAddress> ret = Lists.newArrayList();
        String[] segments = Strings.split(s, ",");
        Logger logger = Loggers.getLogger(this.getClass());
        for (String segment : segments) {
            Map<String, String> stringMap = Regexps.findNamedGroup(IP_PORT_SEGMENT_PATTERN, segment = Strings.strip(segment));
            if (stringMap != null) {
                int port;
                boolean hasBrace;
                String prefixLength;
                String ip = stringMap.get("ip");
                if (Strings.isBlank(ip)) {
                    logger.warn("invalid ip address: {}", (Object)segment);
                }
                if (Strings.isNotEmpty(prefixLength = stringMap.get("prefixLength"))) {
                    ip = ip + "/" + prefixLength;
                }
                int ipv6PortIndex = ip.startsWith("[") ? Strings.indexOf((CharSequence)ip, "]:") : -1;
                String portString = ipv6PortIndex > 0 ? Strings.substring(ip, ipv6PortIndex + 2) : null;
                boolean bl = hasBrace = ip.startsWith("[") && segment.endsWith("]") || ipv6PortIndex > 0;
                ip = hasBrace ? Strings.substring(ip, 1, ipv6PortIndex > 0 ? ipv6PortIndex : ip.length() - 1) : segment;
                portString = Strings.isEmpty(portString) ? stringMap.get("port") : portString;
                int n = port = Strings.isEmpty(portString) ? 0 : Numbers.createInteger(portString);
                if (port > 65535) {
                    logger.warn("invalid port : {}", (Object)segment);
                    continue;
                }
                if (!hasBrace && Regexps.match(RegexpPatterns.PATTERN_IPv4, ip)) {
                    ret.add(new NetworkAddress(ip, port, NetworkAddress.AddrMode.V4));
                    continue;
                }
                if (!hasBrace && Regexps.match("\\w+(-\\w+)?(\\.\\w+(-\\w+)?)*(:\\d{1,5})?", ip)) {
                    Map<String, String> string2Map = Regexps.findNamedGroup(IPv4_PORT_SEGMENT_PATTERN, segment);
                    if (string2Map == null) continue;
                    ip = string2Map.get("ip");
                    if (Strings.isBlank(ip)) {
                        logger.warn("invalid ip address: {}", (Object)segment);
                    }
                    int n2 = port = Strings.isEmpty(portString = string2Map.get("port")) ? 0 : Numbers.createInteger(portString);
                    if (port > 65535) {
                        logger.warn("invalid port : {}", (Object)segment);
                        continue;
                    }
                    NetworkAddress.AddrMode v = NetworkAddress.AddrMode.HOST;
                    if (Regexps.match(RegexpPatterns.PATTERN_IPv4, ip)) {
                        v = NetworkAddress.AddrMode.V4;
                    }
                    ret.add(new NetworkAddress(ip, port, v));
                    continue;
                }
                if (Regexps.match(RegexpPatterns.PATTERN_IPv6, ip)) {
                    ret.add(new NetworkAddress("[" + ip + "]", port, NetworkAddress.AddrMode.V6));
                    continue;
                }
                int portSeparator = Strings.lastIndexOf(segment, ":");
                if (portSeparator >= 1 && portSeparator < segment.length() - 1) {
                    if (':' == segment.charAt(portSeparator - 1)) {
                        logger.warn("invalid ip address: {}", (Object)segment);
                        continue;
                    }
                    portString = Strings.substring(segment, portSeparator + 1);
                    try {
                        port = Strings.isEmpty(portString) ? 0 : Numbers.createInteger(portString);
                    }
                    catch (Exception e) {
                        logger.warn("invalid ip address: {}", (Object)segment);
                        continue;
                    }
                    ip = Strings.substring(segment, 0, portSeparator);
                    if (!hasBrace && Regexps.match(RegexpPatterns.PATTERN_IPv4, ip)) {
                        ret.add(new NetworkAddress(ip, port, NetworkAddress.AddrMode.V4));
                        continue;
                    }
                    if (Regexps.match(RegexpPatterns.PATTERN_IPv6, ip)) {
                        ret.add(new NetworkAddress("[" + ip + "]", port, NetworkAddress.AddrMode.V6));
                        continue;
                    }
                }
                logger.warn("invalid ip address: {}", (Object)segment);
                continue;
            }
            logger.warn("invalid ip address: {}", (Object)segment);
        }
        if (Objs.isNotEmpty(ret)) {
            int unifiedPort;
            boolean portAtEnd = this.supportsPortAtEnd;
            if (this.supportsPortAtEnd) {
                int firstValidPortIndex = Collects.firstOccurrence(ret, new Predicate2<Integer, NetworkAddress>(){

                    @Override
                    public boolean test(Integer index, NetworkAddress address) {
                        return address.getPort() > 0 && address.getPort() < 65535;
                    }
                });
                portAtEnd = firstValidPortIndex == ret.size() - 1;
            }
            int n = unifiedPort = portAtEnd ? ((NetworkAddress)ret.get(ret.size() - 1)).getPort() : this.defaultPort;
            if (unifiedPort > 0) {
                Collects.forEach(ret, new Predicate<NetworkAddress>(){

                    @Override
                    public boolean test(NetworkAddress address) {
                        return address.getPort() < 1;
                    }
                }, new Consumer<NetworkAddress>(){

                    @Override
                    public void accept(NetworkAddress address) {
                        address.setPort(unifiedPort);
                    }
                });
            }
        }
        return ret;
    }

    public String normalize(String s, ClusterAddressStyle style) {
        List<NetworkAddress> addresses = this.parse(s);
        if (Emptys.isEmpty(addresses)) {
            return "";
        }
        return ClusterAddressParser.normalize(addresses, style);
    }

    public String normalize(String s) {
        return this.normalize(s, ClusterAddressStyle.HOST_PORT_PAIR);
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    public static enum ClusterAddressStyle {
        HOST_PORT_PAIR,
        PORT_AT_END;

    }
}

