/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.net;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.codec.hex.Hex;
import com.jn.langx.exception.IllegalParameterException;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.text.properties.PropertiesAccessor;
import com.jn.langx.util.Chars;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Numbers;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Radixs;
import com.jn.langx.util.Strings;
import com.jn.langx.util.SystemPropertys;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.Validations;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.os.Platform;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.RegexpMatcher;
import com.jn.langx.util.regexp.Regexps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;

public class Nets {
    public static final Inet4Address LOCALHOST4;
    public static final Inet4Address INET4_ANY;
    public static final Inet6Address LOCALHOST6;
    public static final Inet4Address INET4_BROADCAST;
    public static final Inet6Address INET6_ANY;
    public static final InetAddress LOCALHOST;
    public static final NetworkInterface LOOPBACK_IF;
    public static final int SOMAXCONN;
    private static final int IPV6_WORD_COUNT = 8;
    private static final int IPV6_MAX_CHAR_COUNT = 39;
    private static final int IPV6_BYTE_COUNT = 16;
    private static final int IPV6_MAX_CHAR_BETWEEN_SEPARATOR = 4;
    private static final int IPV6_MIN_SEPARATORS = 2;
    private static final int IPV6_MAX_SEPARATORS = 8;
    private static final int IPV4_MAX_CHAR_BETWEEN_SEPARATOR = 3;
    private static final int IPV4_SEPARATORS = 3;
    private static final boolean IPV4_PREFERRED;
    private static final boolean IPV6_ADDRESSES_PREFERRED;
    private static final List<String> virtualInterfaces;
    private static final int MAX_DOMAIN_PART_LENGTH = 255;
    private static final String DOMAIN_CHARS_WITHOUT_DASH = "[a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]";
    private static final String DOMAIN_LABEL = "([a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]-*)*[a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]+";
    private static final String DOMAIN = "([a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]-*)*[a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]++(\\.([a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]-*)*[a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]++)*";
    private static final String IP_DOMAIN = "[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}";
    private static final String IP_V6_DOMAIN = "(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))";
    private static final Regexp DOMAIN_PATTERN;
    private static final Regexp EMAIL_DOMAIN_PATTERN;
    private static final int IPV4_PART_COUNT = 4;
    private static final int IPV6_PART_COUNT = 8;
    private static final Regexp NUMERIC;

    private Nets() {
    }

    public static Inet4Address getInet4Address(int s1, int s2, int s3, int s4) {
        byte[] bytes = new byte[4];
        Preconditions.checkArgument(s1 >= 0, "the min value of argument s1 is 0");
        Preconditions.checkArgument(s1 <= 255, "the value value of argument s1 is 255");
        Preconditions.checkArgument(s2 >= 0, "the min value of argument s2 is 0");
        Preconditions.checkArgument(s2 <= 255, "the value value of argument s2 is 255");
        Preconditions.checkArgument(s3 >= 0, "the min value of argument s3 is 0");
        Preconditions.checkArgument(s3 <= 255, "the value value of argument s3 is 255");
        Preconditions.checkArgument(s4 >= 0, "the min value of argument s4 is 0");
        Preconditions.checkArgument(s4 <= 255, "the value value of argument s4 is 255");
        bytes[0] = (byte)s1;
        bytes[1] = (byte)s2;
        bytes[2] = (byte)s3;
        bytes[3] = (byte)s4;
        try {
            return (Inet4Address)InetAddress.getByAddress(s1 + "." + s2 + "." + s3 + "." + s4, bytes);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Inet6Address getInet6Address(int s1, int s2, int s3, int s4, int s5, int s6, int s7, int s8) {
        byte[] bytes = new byte[16];
        Preconditions.checkArgument(s1 >= 0, "the min value of argument s1 is 0");
        Preconditions.checkArgument(s1 <= 65535, "the value value of argument s1 is {}", 65535);
        Preconditions.checkArgument(s2 >= 0, "the min value of argument s1 is 0");
        Preconditions.checkArgument(s2 <= 65535, "the value value of argument s2 is {}", 65535);
        Preconditions.checkArgument(s3 >= 0, "the min value of argument s1 is 0");
        Preconditions.checkArgument(s3 <= 65535, "the value value of argument s3 is {}", 65535);
        Preconditions.checkArgument(s4 >= 0, "the min value of argument s1 is 0");
        Preconditions.checkArgument(s4 <= 65535, "the value value of argument s4 is {}", 65535);
        Preconditions.checkArgument(s5 >= 0, "the min value of argument s1 is 0");
        Preconditions.checkArgument(s5 <= 65535, "the value value of argument s5 is {}", 65535);
        Preconditions.checkArgument(s6 >= 0, "the min value of argument s1 is 0");
        Preconditions.checkArgument(s6 <= 65535, "the value value of argument s6 is {}", 65535);
        Preconditions.checkArgument(s7 >= 0, "the min value of argument s1 is 0");
        Preconditions.checkArgument(s7 <= 65535, "the value value of argument s7 is {}", 65535);
        Preconditions.checkArgument(s8 >= 0, "the min value of argument s1 is 0");
        Preconditions.checkArgument(s8 <= 65535, "the value value of argument s8 is {}", 65535);
        bytes[0] = (byte)(s1 >> 8);
        bytes[1] = (byte)s1;
        bytes[2] = (byte)(s2 >> 8);
        bytes[3] = (byte)s2;
        bytes[4] = (byte)(s3 >> 8);
        bytes[5] = (byte)s3;
        bytes[6] = (byte)(s4 >> 8);
        bytes[7] = (byte)s4;
        bytes[8] = (byte)(s5 >> 8);
        bytes[9] = (byte)s5;
        bytes[10] = (byte)(s6 >> 8);
        bytes[11] = (byte)s6;
        bytes[12] = (byte)(s7 >> 8);
        bytes[13] = (byte)s7;
        bytes[14] = (byte)(s8 >> 8);
        bytes[15] = (byte)s8;
        try {
            return Inet6Address.getByAddress(Nets.toOptimalStringV6(bytes), bytes, 0);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Integer sysctlGetInt(String sysctlKey) throws IOException {
        Integer n;
        BufferedReader br;
        InputStreamReader isr;
        InputStream is;
        Process process;
        block5: {
            Integer n2;
            process = new ProcessBuilder("sysctl", sysctlKey).start();
            is = null;
            isr = null;
            br = null;
            try {
                is = process.getInputStream();
                isr = new InputStreamReader(is, Charsets.UTF_8);
                br = new BufferedReader(isr);
                String line = br.readLine();
                if (line.startsWith(sysctlKey)) {
                    for (int i = line.length() - 1; i > sysctlKey.length(); --i) {
                        if (Character.isDigit(line.charAt(i))) continue;
                        n = Numbers.createInteger(line.substring(i + 1));
                        break block5;
                    }
                }
                n2 = null;
            }
            catch (Throwable throwable) {
                IOs.close(br);
                IOs.close(isr);
                IOs.close(is);
                process.destroy();
                throw throwable;
            }
            IOs.close(br);
            IOs.close(isr);
            IOs.close(is);
            process.destroy();
            return n2;
        }
        IOs.close(br);
        IOs.close(isr);
        IOs.close(is);
        process.destroy();
        return n;
    }

    public static boolean isValidEmailDomainAddress(String domain) {
        return Nets.isValidDomainAddress(domain, EMAIL_DOMAIN_PATTERN);
    }

    public static boolean isValidHostAddress(String str) {
        return Nets.isValidDomainAddress(str) || Nets.isValidIpV6Address(str) || Nets.isValidIpV4Address(str);
    }

    public static boolean isValidDomainAddress(String domain) {
        return Nets.isValidDomainAddress(domain, DOMAIN_PATTERN);
    }

    private static boolean isValidDomainAddress(String domain, Regexp pattern) {
        String asciiString;
        if (domain.endsWith(".")) {
            return false;
        }
        RegexpMatcher matcher = pattern.matcher(domain);
        if (!matcher.matches()) {
            return false;
        }
        try {
            asciiString = IDN.toASCII(domain);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return asciiString.length() <= 255;
    }

    public static boolean isValidIpV6Address(String ip) {
        return Nets.isValidIpV6Address((CharSequence)ip);
    }

    public static boolean isValidIpV6Address(CharSequence ip) {
        int compressBegin;
        int colons;
        int start;
        int end = ip.length();
        if (end < 2) {
            return false;
        }
        char c = ip.charAt(0);
        if (c == '[') {
            if (ip.charAt(--end) != ']') {
                return false;
            }
            start = 1;
            c = ip.charAt(1);
        } else {
            start = 0;
        }
        if (c == ':') {
            if (ip.charAt(start + 1) != ':') {
                return false;
            }
            colons = 2;
            compressBegin = start;
            start += 2;
        } else {
            colons = 0;
            compressBegin = -1;
        }
        int wordLen = 0;
        block5: for (int i = start; i < end; ++i) {
            c = ip.charAt(i);
            if (Nets.isValidHexChar(c)) {
                if (wordLen < 4) {
                    ++wordLen;
                    continue;
                }
                return false;
            }
            switch (c) {
                case ':': {
                    if (colons > 7) {
                        return false;
                    }
                    if (ip.charAt(i - 1) == ':') {
                        if (compressBegin >= 0) {
                            return false;
                        }
                        compressBegin = i - 1;
                    } else {
                        wordLen = 0;
                    }
                    ++colons;
                    continue block5;
                }
                case '.': {
                    if (compressBegin < 0 && colons != 6 || colons == 7 && compressBegin >= start || colons > 7) {
                        return false;
                    }
                    int ipv4Start = i - wordLen;
                    int j = ipv4Start - 2;
                    if (Nets.isValidIPv4MappedChar(ip.charAt(j))) {
                        if (!(Nets.isValidIPv4MappedChar(ip.charAt(j - 1)) && Nets.isValidIPv4MappedChar(ip.charAt(j - 2)) && Nets.isValidIPv4MappedChar(ip.charAt(j - 3)))) {
                            return false;
                        }
                        j -= 5;
                    }
                    while (j >= start) {
                        char tmpChar = ip.charAt(j);
                        if (tmpChar != '0' && tmpChar != ':') {
                            return false;
                        }
                        --j;
                    }
                    int ipv4End = Nets.indexOf(ip, '%', ipv4Start + 7);
                    if (ipv4End < 0) {
                        ipv4End = end;
                    }
                    return Nets.isValidIpV4Address(ip, ipv4Start, ipv4End);
                }
                case '%': {
                    end = i;
                    break block5;
                }
                default: {
                    return false;
                }
            }
        }
        if (compressBegin < 0) {
            return colons == 7 && wordLen > 0;
        }
        return compressBegin + 2 == end || wordLen > 0 && (colons < 8 || compressBegin <= start);
    }

    private static boolean isValidIpV4Word(String word) {
        int num = Numbers.createInteger(word);
        return num >= 0 && num <= 255;
    }

    private static boolean isValidHexChar(char c) {
        return Chars.isNumber(c) || Chars.isLowOrUpperCase(c);
    }

    private static boolean isValidIPv4MappedChar(char c) {
        return c == 'f' || c == 'F';
    }

    private static boolean isValidIPv4MappedSeparators(byte b0, byte b1, boolean mustBeZero) {
        return b0 == b1 && (b0 == 0 || !mustBeZero && b1 == -1);
    }

    private static boolean isValidIPv4Mapped(byte[] bytes, int currentIndex, int compressBegin, int compressLength) {
        boolean mustBeZero = compressBegin + compressLength >= 14;
        return currentIndex <= 12 && currentIndex >= 2 && (!mustBeZero || compressBegin < 12) && Nets.isValidIPv4MappedSeparators(bytes[currentIndex - 1], bytes[currentIndex - 2], mustBeZero) && Nets.isZero(bytes, 0, currentIndex - 3);
    }

    private static boolean isZero(byte[] bytes, int startPos, int length) {
        if (length <= 0) {
            return true;
        }
        int end = startPos + length;
        while (startPos < end) {
            if (bytes[startPos] != 0) {
                return false;
            }
            ++startPos;
        }
        return true;
    }

    public static int ipv4AddressToInt(Inet4Address ipAddress) {
        byte[] octets = ipAddress.getAddress();
        return Nets.ipAddressToLong(octets).intValue();
    }

    public static Long ipAddressToLong(byte[] ip) {
        long result = 0L;
        for (int i = 0; i < ip.length; ++i) {
            byte octet = ip[i];
            if (i > 0) {
                result <<= 8;
            }
            result |= (long)(octet & 0xFF);
        }
        return result;
    }

    public static Long ipAddressToLong(String ipAddress) {
        byte[] bytes = Nets.createByteArrayFromIpAddressString(ipAddress);
        if (bytes != null) {
            if (bytes.length == 4) {
                return Nets.ipAddressToLong(bytes);
            }
            if (bytes.length == 16) {
                return Nets.ipAddressToLong(bytes);
            }
        }
        throw new IllegalParameterException(StringTemplates.formatWithPlaceholder("invalid ip address: {}", ipAddress));
    }

    public static int ipv4AddressToInt(String ipv4) {
        return Nets.ipAddressToLong(ipv4).intValue();
    }

    public static long ipv6AddressToLong(String ipv6) {
        return Nets.ipAddressToLong(ipv6);
    }

    public static String ipv4MappingToIpv6(String ipv4) {
        return Nets.ipv4MappingToIpv6(ipv4, false);
    }

    public static String ipv4MappingToIpv6(String ipv4, boolean optimal) {
        byte[] ipv4Bytes = Nets.createByteArrayFromIpAddressString(ipv4);
        byte[] ipv6Bytes = Nets.ipv4MappingToIpv6Bytes(ipv4Bytes);
        return Nets.toIpv6Address(ipv6Bytes, optimal);
    }

    public static String toIpv6Address(byte[] bytes) {
        return Nets.toIpv6Address(bytes, false);
    }

    public static String toIpv6Address(byte[] bytes, boolean optimal) {
        if (bytes.length != 16) {
            throw new IllegalArgumentException("invalid ipv6 address");
        }
        if (optimal) {
            return Nets.toOptimalStringV6(bytes);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            if (i != 0) {
                builder.append(":");
            }
            builder.append(Hex.DECIMAL_TO_DIGITS_UPPER[(0xF0 & bytes[i]) >> 4]);
            builder.append(Hex.DECIMAL_TO_DIGITS_UPPER[0xF & bytes[i]]);
            builder.append(Hex.DECIMAL_TO_DIGITS_UPPER[(0xF0 & bytes[++i]) >> 4]);
            builder.append(Hex.DECIMAL_TO_DIGITS_UPPER[0xF & bytes[i]]);
        }
        return builder.toString();
    }

    public static byte[] ipv4MappingToIpv6Bytes(byte[] ipv4Bytes) {
        int i;
        if (ipv4Bytes == null || ipv4Bytes.length != 4) {
            throw new IllegalParameterException(StringTemplates.formatWithPlaceholder("illegal ipv4 address: {}", Objs.isEmpty(ipv4Bytes) ? "" : new String(ipv4Bytes, Charsets.UTF_8)));
        }
        byte[] ipv6Bytes = new byte[16];
        for (i = 0; i < 10; ++i) {
            ipv6Bytes[i] = 0;
        }
        for (i = 10; i < 12; ++i) {
            ipv6Bytes[i] = -1;
        }
        for (i = 12; i < 16; ++i) {
            ipv6Bytes[i] = ipv4Bytes[i - 12];
        }
        return ipv6Bytes;
    }

    public static String intToIpv4Address(int i) {
        String buf = String.valueOf(i >> 24 & 0xFF) + '.' + (i >> 16 & 0xFF) + '.' + (i >> 8 & 0xFF) + '.' + (i & 0xFF);
        return buf;
    }

    public static boolean isValidIpV4Address(String ip) {
        return Nets.isValidIpV4Address(ip, 0, ip.length());
    }

    private static boolean isValidIpV4Address(CharSequence ip, int from, int toExcluded) {
        return Nets.isValidIpV4Address((String)ip, from, toExcluded);
    }

    private static boolean isValidIpV4Address(String ip, int from, int toExcluded) {
        int len = toExcluded - from;
        if (len <= 15 && len >= 7) {
            String[] words = Strings.split(ip, ":");
            if (words.length != 4) {
                return false;
            }
            return Pipeline.of(words).allMatch(new Predicate<String>(){

                @Override
                public boolean test(String word) {
                    return Nets.isValidIpV4Word(word);
                }
            });
        }
        return false;
    }

    public static boolean isValidPort(int port) {
        return Validations.isValidPort(port);
    }

    public static int indexOf(CharSequence cs, char searchChar, int start) {
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start);
        }
        if (cs == null) {
            return -1;
        }
        int sz = cs.length();
        for (int i = Math.max(start, 0); i < sz; ++i) {
            if (cs.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static Inet6Address getV6ByName(CharSequence ip) {
        return Nets.getV6ByName(ip, true);
    }

    public static Inet6Address getV6ByName(CharSequence ip, boolean ipv4Mapped) {
        byte[] bytes = Nets.getIPv6ByName(ip, ipv4Mapped);
        if (bytes == null) {
            return null;
        }
        try {
            return Inet6Address.getByAddress(null, bytes, -1);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getIPv6ByName(CharSequence ip, boolean ipv4Mapped) {
        boolean isCompressed;
        int tmp;
        int i;
        byte[] bytes = new byte[16];
        int ipLength = ip.length();
        int compressBegin = 0;
        int compressLength = 0;
        int currentIndex = 0;
        int value = 0;
        int begin = -1;
        int ipv6Separators = 0;
        int ipv4Separators = 0;
        boolean needsShift = false;
        block4: for (i = 0; i < ipLength; ++i) {
            char c = ip.charAt(i);
            switch (c) {
                case ':': {
                    if (i - begin > 4 || ipv4Separators > 0 || ++ipv6Separators > 8 || currentIndex + 1 >= bytes.length) {
                        return null;
                    }
                    value <<= 4 - (i - begin) << 2;
                    if (compressLength > 0) {
                        compressLength -= 2;
                    }
                    bytes[currentIndex++] = (byte)((value & 0xF) << 4 | value >> 4 & 0xF);
                    bytes[currentIndex++] = (byte)((value >> 8 & 0xF) << 4 | value >> 12 & 0xF);
                    tmp = i + 1;
                    if (tmp < ipLength && ip.charAt(tmp) == ':') {
                        if (compressBegin != 0 || ++tmp < ipLength && ip.charAt(tmp) == ':') {
                            return null;
                        }
                        needsShift = ++ipv6Separators == 2 && value == 0;
                        compressBegin = currentIndex;
                        compressLength = bytes.length - compressBegin - 2;
                        ++i;
                    }
                    value = 0;
                    begin = -1;
                    continue block4;
                }
                case '.': {
                    tmp = i - begin;
                    if (tmp > 3 || begin < 0 || ++ipv4Separators > 3 || ipv6Separators > 0 && currentIndex + compressLength < 12 || i + 1 >= ipLength || currentIndex >= bytes.length || ipv4Separators == 1 && (!ipv4Mapped || currentIndex != 0 && !Nets.isValidIPv4Mapped(bytes, currentIndex, compressBegin, compressLength) || tmp == 3 && (!Chars.isNumber(ip.charAt(i - 1)) || !Chars.isNumber(ip.charAt(i - 2)) || !Chars.isNumber(ip.charAt(i - 3))) || tmp == 2 && (!Chars.isNumber(ip.charAt(i - 1)) || !Chars.isNumber(ip.charAt(i - 2))) || tmp == 1 && !Chars.isNumber(ip.charAt(i - 1)))) {
                        return null;
                    }
                    if ((begin = ((value <<= 3 - tmp << 2) & 0xF) * 100 + (value >> 4 & 0xF) * 10 + (value >> 8 & 0xF)) > 255) {
                        return null;
                    }
                    bytes[currentIndex++] = (byte)begin;
                    value = 0;
                    begin = -1;
                    continue block4;
                }
                default: {
                    if (!Nets.isValidHexChar(c) || ipv4Separators > 0 && !Chars.isNumber(c)) {
                        return null;
                    }
                    if (begin < 0) {
                        begin = i;
                    } else if (i - begin > 4) {
                        return null;
                    }
                    value += Strings.decodeHexNibble(c) << (i - begin << 2);
                }
            }
        }
        boolean bl = isCompressed = compressBegin > 0;
        if (ipv4Separators > 0) {
            if (begin > 0 && i - begin > 3 || ipv4Separators != 3 || currentIndex >= bytes.length) {
                return null;
            }
            if (ipv6Separators == 0) {
                compressLength = 12;
            } else if (ipv6Separators >= 2 && (!isCompressed && ipv6Separators == 6 && ip.charAt(0) != ':' || isCompressed && ipv6Separators < 8 && (ip.charAt(0) != ':' || compressBegin <= 2))) {
                compressLength -= 2;
            } else {
                return null;
            }
            value <<= 3 - (i - begin) << 2;
            begin = (value & 0xF) * 100 + (value >> 4 & 0xF) * 10 + (value >> 8 & 0xF);
            if (begin > 255) {
                return null;
            }
            bytes[currentIndex++] = (byte)begin;
        } else {
            tmp = ipLength - 1;
            if (begin > 0 && i - begin > 4 || ipv6Separators < 2 || !isCompressed && (ipv6Separators + 1 != 8 || ip.charAt(0) == ':' || ip.charAt(tmp) == ':') || isCompressed && (ipv6Separators > 8 || ipv6Separators == 8 && (compressBegin <= 2 && ip.charAt(0) != ':' || compressBegin >= 14 && ip.charAt(tmp) != ':')) || currentIndex + 1 >= bytes.length || begin < 0 && ip.charAt(tmp - 1) != ':' || compressBegin > 2 && ip.charAt(0) == ':') {
                return null;
            }
            if (begin >= 0 && i - begin <= 4) {
                value <<= 4 - (i - begin) << 2;
            }
            bytes[currentIndex++] = (byte)((value & 0xF) << 4 | value >> 4 & 0xF);
            bytes[currentIndex++] = (byte)((value >> 8 & 0xF) << 4 | value >> 12 & 0xF);
        }
        i = currentIndex + compressLength;
        if (needsShift || i >= bytes.length) {
            if (i >= bytes.length) {
                ++compressBegin;
            }
            for (i = currentIndex; i < bytes.length; ++i) {
                for (begin = bytes.length - 1; begin >= compressBegin; --begin) {
                    bytes[begin] = bytes[begin - 1];
                }
                bytes[begin] = 0;
                ++compressBegin;
            }
        } else {
            for (i = 0; i < compressLength && (currentIndex = (begin = i + compressBegin) + compressLength) < bytes.length; ++i) {
                bytes[currentIndex] = bytes[begin];
                bytes[begin] = 0;
            }
        }
        if (ipv4Separators > 0) {
            bytes[11] = -1;
            bytes[10] = -1;
        }
        return bytes;
    }

    public static InetAddress forString(String ipString) {
        byte[] addr = Nets.textToNumericFormatV4(ipString);
        if (addr == null) {
            addr = Nets.textToNumericFormatV6(ipString);
        }
        if (addr == null) {
            throw new IllegalArgumentException(String.format("'%s' is not an IP string literal.", ipString));
        }
        try {
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("'%s' is extremely broken.", ipString), e);
        }
    }

    public static boolean isInetAddress(String ipString) {
        try {
            Nets.forString(ipString);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static byte[] textToNumericFormatV4(String ipString) {
        if (ipString.contains(":")) {
            return null;
        }
        String[] address = ipString.split("\\.");
        if (address.length != 4) {
            return null;
        }
        byte[] bytes = new byte[4];
        try {
            for (int i = 0; i < bytes.length; ++i) {
                int piece = Integer.parseInt(address[i]);
                if (piece < 0 || piece > 255) {
                    return null;
                }
                if (address[i].startsWith("0") && address[i].length() != 1) {
                    return null;
                }
                bytes[i] = (byte)piece;
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return bytes;
    }

    private static byte[] textToNumericFormatV6(String ipString) {
        int totalParts;
        int i;
        String[] parts;
        if (!ipString.contains(":")) {
            return null;
        }
        if (ipString.contains(":::")) {
            return null;
        }
        if (ipString.contains(".") && (ipString = Nets.convertDottedQuadToHex(ipString)) == null) {
            return null;
        }
        ByteBuffer rawBytes = ByteBuffer.allocate(16);
        int partsHi = 0;
        int partsLo = 0;
        String[] addressHalves = ipString.split("::", 2);
        if (!addressHalves[0].equals("")) {
            parts = addressHalves[0].split(":", 8);
            try {
                for (i = 0; i < parts.length; ++i) {
                    if (parts[i].equals("")) {
                        return null;
                    }
                    int piece = Integer.parseInt(parts[i], 16);
                    rawBytes.putShort(2 * i, (short)piece);
                }
                partsHi = parts.length;
            }
            catch (NumberFormatException ex) {
                return null;
            }
        } else {
            partsHi = 1;
        }
        if (addressHalves.length > 1) {
            if (!addressHalves[1].equals("")) {
                parts = addressHalves[1].split(":", 8);
                try {
                    for (i = 0; i < parts.length; ++i) {
                        int partsIndex = parts.length - i - 1;
                        if (parts[partsIndex].equals("")) {
                            return null;
                        }
                        int piece = Integer.parseInt(parts[partsIndex], 16);
                        int bytesIndex = 2 * (8 - i - 1);
                        rawBytes.putShort(bytesIndex, (short)piece);
                    }
                    partsLo = parts.length;
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            } else {
                partsLo = 1;
            }
        }
        if ((totalParts = partsHi + partsLo) > 8) {
            return null;
        }
        if (addressHalves.length == 1 && totalParts != 8) {
            return null;
        }
        return rawBytes.array();
    }

    private static String convertDottedQuadToHex(String ipString) {
        int lastColon = ipString.lastIndexOf(58);
        String initialPart = ipString.substring(0, lastColon + 1);
        String dottedQuad = ipString.substring(lastColon + 1);
        byte[] quad = Nets.textToNumericFormatV4(dottedQuad);
        if (quad == null) {
            return null;
        }
        String penultimate = Integer.toHexString((quad[0] & 0xFF) << 8 | quad[1] & 0xFF);
        String ultimate = Integer.toHexString((quad[2] & 0xFF) << 8 | quad[3] & 0xFF);
        return initialPart + penultimate + ":" + ultimate;
    }

    public static InetAddress forUriString(String hostAddr) {
        InetAddress retval = null;
        try {
            retval = Nets.forString(hostAddr);
            if (retval instanceof Inet4Address) {
                return retval;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (!hostAddr.startsWith("[") || !hostAddr.endsWith("]")) {
            throw new IllegalArgumentException("Not a valid address: \"" + hostAddr + '\"');
        }
        retval = Nets.forString(hostAddr.substring(1, hostAddr.length() - 1));
        if (retval instanceof Inet6Address) {
            return retval;
        }
        throw new IllegalArgumentException("Not a valid address: \"" + hostAddr + '\"');
    }

    public static String toSocketAddressString(InetSocketAddress addr) {
        StringBuilder sb;
        String port = String.valueOf(addr.getPort());
        if (addr.isUnresolved()) {
            String hostname;
            sb = Nets.newSocketAddressStringBuilder(hostname, port, !Nets.isValidIpV6Address(hostname = Nets.getHostname(addr)));
        } else {
            InetAddress address = addr.getAddress();
            String hostString = Nets.toAddressString(address);
            sb = Nets.newSocketAddressStringBuilder(hostString, port, address instanceof Inet4Address);
        }
        return sb.append(':').append(port).toString();
    }

    public static String toSocketAddressString(String host, int port) {
        String portStr = String.valueOf(port);
        return Nets.newSocketAddressStringBuilder(host, portStr, !Nets.isValidIpV6Address(host)).append(':').append(portStr).toString();
    }

    private static StringBuilder newSocketAddressStringBuilder(String host, String port, boolean ipv4) {
        int hostLen = host.length();
        if (ipv4) {
            return new StringBuilder(hostLen + 1 + port.length()).append(host);
        }
        StringBuilder stringBuilder = new StringBuilder(hostLen + 3 + port.length());
        if (hostLen > 1 && host.charAt(0) == '[' && host.charAt(hostLen - 1) == ']') {
            return stringBuilder.append(host);
        }
        return stringBuilder.append('[').append(host).append(']');
    }

    public static String toAddressString(InetAddress ip) {
        return Nets.toAddressString(ip, false);
    }

    public static String toAddressString(InetAddress ip, boolean ipv4Mapped) {
        if (ip instanceof Inet4Address) {
            return ip.getHostAddress();
        }
        if (!(ip instanceof Inet6Address)) {
            throw new IllegalArgumentException("Unhandled type: " + ip);
        }
        return Nets.toAddressString(ip.getAddress(), 0, ipv4Mapped);
    }

    private static String toAddressString(byte[] bytes, int offset, boolean ipv4Mapped) {
        int currentLength;
        int i;
        int[] words = new int[8];
        int end = offset + words.length;
        for (i = offset; i < end; ++i) {
            words[i] = (bytes[i << 1] & 0xFF) << 8 | bytes[(i << 1) + 1] & 0xFF;
        }
        int currentStart = -1;
        int shortestStart = -1;
        int shortestLength = 0;
        for (i = 0; i < words.length; ++i) {
            if (words[i] == 0) {
                if (currentStart >= 0) continue;
                currentStart = i;
                continue;
            }
            if (currentStart < 0) continue;
            currentLength = i - currentStart;
            if (currentLength > shortestLength) {
                shortestStart = currentStart;
                shortestLength = currentLength;
            }
            currentStart = -1;
        }
        if (currentStart >= 0 && (currentLength = i - currentStart) > shortestLength) {
            shortestStart = currentStart;
            shortestLength = currentLength;
        }
        if (shortestLength == 1) {
            shortestLength = 0;
            shortestStart = -1;
        }
        int shortestEnd = shortestStart + shortestLength;
        StringBuilder b = new StringBuilder(39);
        if (shortestEnd < 0) {
            b.append(Integer.toHexString(words[0]));
            for (i = 1; i < words.length; ++i) {
                b.append(':');
                b.append(Integer.toHexString(words[i]));
            }
        } else {
            boolean isIpv4Mapped;
            if (Validations.inRange(0, shortestStart, shortestEnd)) {
                b.append("::");
                isIpv4Mapped = ipv4Mapped && shortestEnd == 5 && words[5] == 65535;
            } else {
                b.append(Integer.toHexString(words[0]));
                isIpv4Mapped = false;
            }
            for (i = 1; i < words.length; ++i) {
                if (!Validations.inRange(i, shortestStart, shortestEnd)) {
                    if (!Validations.inRange(i - 1, shortestStart, shortestEnd)) {
                        if (!isIpv4Mapped || i == 6) {
                            b.append(':');
                        } else {
                            b.append('.');
                        }
                    }
                    if (isIpv4Mapped && i > 5) {
                        b.append(words[i] >> 8);
                        b.append('.');
                        b.append(words[i] & 0xFF);
                        continue;
                    }
                    b.append(Integer.toHexString(words[i]));
                    continue;
                }
                if (Validations.inRange(i - 1, shortestStart, shortestEnd)) continue;
                b.append("::");
            }
        }
        return b.toString();
    }

    public static String getHostname(InetSocketAddress addr) {
        if (Platform.JAVA_VERSION_INT < 7) {
            return addr.getHostName();
        }
        try {
            return (String)Reflects.invokePublicMethod(addr, "getHostString", null, null, true, true);
        }
        catch (Exception ex) {
            return addr.getHostName();
        }
    }

    public static Enumeration<InetAddress> addressesFromNetworkInterface(final NetworkInterface intf) {
        return AccessController.doPrivileged(new PrivilegedAction<Enumeration<InetAddress>>(){

            @Override
            public Enumeration<InetAddress> run() {
                return intf.getInetAddresses();
            }
        });
    }

    public static byte[] createByteArrayFromIpAddressString(String ipAddressString) {
        if (Nets.isValidIpV4Address(ipAddressString)) {
            return Nets.validIpV4ToBytes(ipAddressString);
        }
        if (Nets.isValidIpV6Address(ipAddressString)) {
            int percentPos;
            if (ipAddressString.charAt(0) == '[') {
                ipAddressString = ipAddressString.substring(1, ipAddressString.length() - 1);
            }
            if ((percentPos = ipAddressString.indexOf(37)) >= 0) {
                ipAddressString = ipAddressString.substring(0, percentPos);
            }
            return Nets.getIPv6ByName(ipAddressString, true);
        }
        return null;
    }

    static byte[] validIpV4ToBytes(String ip) {
        String[] segments = Strings.split(ip, ".");
        byte[] bytes = new byte[segments.length];
        for (int i = 0; i < segments.length; ++i) {
            byte octet;
            bytes[i] = octet = Numbers.createByte(segments[i]).byteValue();
        }
        return bytes;
    }

    public static Map<String, Set<InetAddress>> getNetworkInterfaceAddresses() {
        return Nets.getNetworkInterfaceAddresses(new Predicate<NetworkInterface>(){

            @Override
            public boolean test(NetworkInterface iface) {
                try {
                    return iface.isUp() && !iface.isLoopback() && !iface.isPointToPoint();
                }
                catch (SocketException ex) {
                    return false;
                }
            }
        }, new Predicate<InetAddress>(){

            @Override
            public boolean test(InetAddress ia) {
                return !ia.isLoopbackAddress() && !ia.getHostAddress().contains(":");
            }
        });
    }

    public static Map<String, Set<InetAddress>> getNetworkInterfaceAddresses(@Nullable Predicate<NetworkInterface> networkInterfacePredicate, @Nullable Predicate<InetAddress> inetAddressPredicate) {
        TreeMap<String, Set<InetAddress>> interfaceAddressMap = new TreeMap<String, Set<InetAddress>>();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            networkInterfacePredicate = networkInterfacePredicate == null ? Functions.truePredicate() : networkInterfacePredicate;
            Predicate<Object> predicate = inetAddressPredicate = inetAddressPredicate == null ? Functions.truePredicate() : inetAddressPredicate;
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (!networkInterfacePredicate.test(iface)) continue;
                String name = iface.getName();
                Enumeration<InetAddress> ifaceAddresses = iface.getInetAddresses();
                while (ifaceAddresses.hasMoreElements()) {
                    InetAddress ia = ifaceAddresses.nextElement();
                    if (!inetAddressPredicate.test(ia)) continue;
                    LinkedHashSet<InetAddress> addresses = (LinkedHashSet<InetAddress>)interfaceAddressMap.get(name);
                    if (addresses == null) {
                        addresses = new LinkedHashSet<InetAddress>();
                    }
                    addresses.add(ia);
                    interfaceAddressMap.put(name, addresses);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return interfaceAddressMap;
    }

    public static List<NetworkInterface> getNetworkInterfaces() {
        return Nets.getNetworkInterfaces(null);
    }

    public static List<NetworkInterface> getNetworkInterfaces(Predicate<NetworkInterface> predicate) {
        predicate = predicate == null ? Functions.truePredicate() : predicate;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            return Pipeline.of(enumeration).filter(new Predicate<NetworkInterface>(){

                @Override
                public boolean test(NetworkInterface itfc) {
                    return !itfc.isVirtual();
                }
            }).filter(new Predicate<NetworkInterface>(){

                @Override
                public boolean test(NetworkInterface itfc) {
                    try {
                        return itfc.isUp();
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            }).filter(predicate).asList();
        }
        catch (SocketException socketException) {
            return Collects.emptyArrayList();
        }
    }

    public static List<NetworkInterface> getValidNetworkInterfaces() {
        return Nets.getValidNetworkInterfaces(virtualInterfaces);
    }

    public static List<NetworkInterface> getValidNetworkInterfaces(final List<String> virtualInterfaces) {
        Preconditions.checkNotEmpty(virtualInterfaces);
        List<NetworkInterface> interfaces = Nets.getNetworkInterfaces();
        return Pipeline.of(interfaces).filter(new Predicate<NetworkInterface>(){

            @Override
            public boolean test(NetworkInterface networkInterface) {
                return !networkInterface.isVirtual();
            }
        }).filter(new Predicate<NetworkInterface>(){

            @Override
            public boolean test(NetworkInterface networkInterface) {
                try {
                    return networkInterface.isUp();
                }
                catch (IOException e) {
                    return false;
                }
            }
        }).filter(new Predicate<NetworkInterface>(){

            @Override
            public boolean test(NetworkInterface networkInterface) {
                try {
                    return !networkInterface.isLoopback();
                }
                catch (IOException e) {
                    return false;
                }
            }
        }).filter(new Predicate<NetworkInterface>(){

            @Override
            public boolean test(NetworkInterface networkInterface) {
                final String displayName = networkInterface.getDisplayName();
                if (Collects.anyMatch(virtualInterfaces, new Predicate<String>(){

                    @Override
                    public boolean test(String value) {
                        return Strings.contains(displayName, value, true);
                    }
                })) {
                    return false;
                }
                final String name = networkInterface.getName();
                if (Collects.anyMatch(virtualInterfaces, new Predicate<String>(){

                    @Override
                    public boolean test(String value) {
                        return Strings.contains(name, value, true);
                    }
                })) {
                    return false;
                }
                try {
                    return Emptys.isNotEmpty(networkInterface.getHardwareAddress());
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }).asList();
    }

    public static NetworkInterface getFirstValidNetworkInterface() {
        return Pipeline.of(Nets.getValidNetworkInterfaces()).findFirst();
    }

    public static String getFirstValidMac() {
        NetworkInterface networkInterface = Nets.getFirstValidNetworkInterface();
        return Nets.getMac(networkInterface);
    }

    @Nullable
    public static String getMac(@NonNull NetworkInterface networkInterface) {
        if (networkInterface == null) {
            return null;
        }
        byte[] macBytes = null;
        try {
            macBytes = networkInterface.getHardwareAddress();
        }
        catch (SocketException ex) {
            return null;
        }
        if (Emptys.isNotEmpty(macBytes)) {
            return Nets.getMac(macBytes);
        }
        return null;
    }

    public static String getMac(@NonNull byte[] bytes) {
        Preconditions.checkArgument(Emptys.isNotEmpty(bytes), "invalid mac bytes");
        StringBuilder mac = new StringBuilder();
        boolean first = false;
        for (byte b : bytes) {
            if (first) {
                mac.append("-");
            }
            byte currentByte = (byte)((b & 0xF0) >> 4);
            mac.append(String.format("%02X", currentByte));
            currentByte = (byte)(b & 0xF);
            mac.append(String.format("%02X", currentByte));
            first = true;
        }
        return mac.toString().toUpperCase();
    }

    public static Set<InetAddress> getAddresses() {
        LinkedHashSet<InetAddress> allAddresses = new LinkedHashSet<InetAddress>();
        Map<String, Set<InetAddress>> interfaceAddressMap = Nets.getNetworkInterfaceAddresses();
        for (Map.Entry<String, Set<InetAddress>> entry : interfaceAddressMap.entrySet()) {
            Set<InetAddress> addresses = entry.getValue();
            if (addresses.isEmpty()) continue;
            allAddresses.addAll(addresses);
        }
        return allAddresses;
    }

    public static InetAddress getCurrentAddress() {
        try {
            return Nets.chooseAddress();
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    private static InetAddress chooseAddress() throws UnknownHostException {
        Set<InetAddress> addresses = Nets.getAddresses();
        if (addresses.contains(InetAddress.getLocalHost())) {
            return InetAddress.getLocalHost();
        }
        if (Emptys.isNotEmpty(addresses)) {
            return addresses.toArray(new InetAddress[0])[0];
        }
        return InetAddress.getLocalHost();
    }

    public static String getLocalHostName() throws UnknownHostException {
        return Nets.chooseAddress().getHostName();
    }

    public static String getLocalIp() throws UnknownHostException {
        return Nets.chooseAddress().getHostAddress();
    }

    public static int getScopeId(InetAddress address) {
        return address instanceof Inet6Address ? ((Inet6Address)address).getScopeId() : 0;
    }

    public static int getScopeId(String scopeName) {
        return Nets.getScopeId(scopeName, null);
    }

    public static int getScopeId(String scopeName, InetAddress compareWith) {
        Preconditions.checkNotNullArgument(scopeName, "scopeName");
        if (NUMERIC.matcher(scopeName).matches()) {
            try {
                return Integer.parseInt(scopeName);
            }
            catch (NumberFormatException ignored) {
                return 0;
            }
        }
        NetworkInterface ni = Nets.findInterfaceWithScopeId(scopeName);
        if (ni == null) {
            return 0;
        }
        return Nets.getScopeId(ni, compareWith);
    }

    public static NetworkInterface findInterfaceWithScopeId(String scopeName) {
        Enumeration<NetworkInterface> enumeration;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ignored) {
            return null;
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface net = enumeration.nextElement();
            if (!net.getName().equals(scopeName)) continue;
            return net;
        }
        return null;
    }

    public static int getScopeId(NetworkInterface networkInterface) {
        return Nets.getScopeId(networkInterface, null);
    }

    public static int getScopeId(final NetworkInterface networkInterface, InetAddress compareWith) {
        Preconditions.checkNotNullArgument(networkInterface, "networkInterface");
        final Inet6Address cw6 = compareWith instanceof Inet6Address ? (Inet6Address)compareWith : null;
        Inet6Address address = AccessController.doPrivileged(new PrivilegedAction<Inet6Address>(){

            @Override
            public Inet6Address run() {
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress a = addresses.nextElement();
                    if (!(a instanceof Inet6Address)) continue;
                    Inet6Address a6 = (Inet6Address)a;
                    if (cw6 != null && (a6.isLinkLocalAddress() != cw6.isLinkLocalAddress() || a6.isSiteLocalAddress() != cw6.isSiteLocalAddress())) continue;
                    return a6;
                }
                return null;
            }
        });
        return address == null ? 0 : address.getScopeId();
    }

    public static String toOptimalString(InetAddress inetAddress) {
        Preconditions.checkNotNullArgument(inetAddress, "inetAddress");
        return inetAddress instanceof Inet6Address ? Nets.toOptimalStringV6(inetAddress.getAddress()) : inetAddress.getHostAddress();
    }

    public static String toOptimalString(byte[] addressBytes) {
        Preconditions.checkNotNullArgument(addressBytes, "addressBytes");
        if (addressBytes.length == 4) {
            return (addressBytes[0] & 0xFF) + "." + (addressBytes[1] & 0xFF) + "." + (addressBytes[2] & 0xFF) + "." + (addressBytes[3] & 0xFF);
        }
        if (addressBytes.length == 16) {
            return Nets.toOptimalStringV6(addressBytes);
        }
        throw new RuntimeException(StringTemplates.formatWithPlaceholder("illegal network address length: {}", addressBytes.length));
    }

    private static String toOptimalStringV6(byte[] bytes) {
        int[] segments = new int[8];
        for (int i = 0; i < 8; ++i) {
            segments[i] = (bytes[i << 1] & 0xFF) << 8 | bytes[(i << 1) + 1] & 0xFF;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            if (segments[i] == 0) {
                if (i == 7) {
                    b.append('0');
                    continue;
                }
                if (segments[++i] == 0) {
                    b.append(':').append(':');
                    ++i;
                    while (i < 8) {
                        if (segments[i] == 65535 && b.length() == 2) {
                            b.append("ffff");
                            if (i == 5) {
                                b.append(':').append(bytes[12] & 0xFF).append('.').append(bytes[13] & 0xFF).append('.').append(bytes[14] & 0xFF).append('.').append(bytes[15] & 0xFF);
                                i = 8;
                            } else if (i == 4 && segments[5] == 0) {
                                b.append(":0:").append(bytes[12] & 0xFF).append('.').append(bytes[13] & 0xFF).append('.').append(bytes[14] & 0xFF).append('.').append(bytes[15] & 0xFF);
                                i = 8;
                            } else {
                                ++i;
                                while (i < 8) {
                                    b.append(':').append(Integer.toHexString(segments[i]));
                                    ++i;
                                }
                            }
                        } else if (segments[i] != 0) {
                            b.append(Integer.toHexString(segments[i]));
                            ++i;
                            while (i < 8) {
                                b.append(':').append(Integer.toHexString(segments[i]));
                                ++i;
                            }
                        }
                        ++i;
                    }
                    continue;
                }
                if (i > 1) {
                    b.append(':');
                }
                b.append('0').append(':').append(Integer.toHexString(segments[i]));
                continue;
            }
            if (i > 0) {
                b.append(':');
            }
            b.append(Integer.toHexString(segments[i]));
        }
        return b.toString();
    }

    public static boolean ping(String host) {
        return Nets.ping(host, 200);
    }

    public static boolean ping(String host, int timeout) {
        try {
            return InetAddress.getByName(host).isReachable(timeout);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getIpv4SubnetMask(int prefixLength) {
        Preconditions.checkArgument(Nets.isValidIpv4SubnetMask(prefixLength), "invalid ipv4 netmask prefix: {}", prefixLength);
        String prefixBitsString = Strings.repeat("1", prefixLength);
        String suffixBitsString = Strings.repeat("0", 32 - prefixLength);
        String subnetMaskBitsString = prefixBitsString + suffixBitsString;
        String[] segments = Strings.slice(subnetMaskBitsString, 8);
        String subnetMask = Pipeline.of(segments).map(new Function<String, String>(){

            @Override
            public String apply(String segment) {
                return Radixs.binaryToDecimal(segment) + "";
            }
        }).join(".");
        return subnetMask;
    }

    public static boolean isValidIpv4SubnetMask(int prefix) {
        return prefix >= 1 && prefix <= 32;
    }

    public static boolean isValidIpv4SubnetMask(String subnetMask) {
        int prefix = Nets.getIpv4SubnetMaskPrefixLength(subnetMask);
        return Nets.isValidIpv4SubnetMask(prefix);
    }

    public static int getIpv4SubnetMaskPrefixLength(String subnetMask) {
        char c;
        int i;
        if (!Nets.isValidIpV4Address(subnetMask)) {
            return -1;
        }
        String[] segments = Strings.split(subnetMask, false, ".", true, true);
        List<String> bitsList = Pipeline.of(segments).map(new Function<String, String>(){

            @Override
            public String apply(String segment) {
                String binary = Radixs.toBinary(Numbers.createInteger(segment));
                if (binary.length() < 8) {
                    binary = binary + Strings.repeat("0", 8 - binary.length());
                }
                return binary;
            }
        }).asList();
        String subnetMaskBitsString = Strings.join("", bitsList);
        if (subnetMaskBitsString.length() != 32) {
            return -1;
        }
        int prefix = -1;
        int maxCount = subnetMaskBitsString.length();
        for (i = 0; i < subnetMaskBitsString.length(); ++i) {
            c = subnetMaskBitsString.charAt(i);
            if (c != '0') continue;
            prefix = i;
            break;
        }
        if (prefix == -1) {
            prefix = maxCount;
        }
        if (prefix < maxCount) {
            for (i = prefix + 1; i < maxCount; ++i) {
                c = subnetMaskBitsString.charAt(i);
                if (c != '1') continue;
                prefix = -1;
                break;
            }
        }
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Enumeration<InetAddress> i;
        INET4_ANY = Nets.getInet4Address(0, 0, 0, 0);
        INET4_BROADCAST = Nets.getInet4Address(255, 255, 255, 255);
        INET6_ANY = Nets.getInet6Address(0, 0, 0, 0, 0, 0, 0, 0);
        final PropertiesAccessor systemPropertiesAccessor = SystemPropertys.getAccessor();
        IPV4_PREFERRED = systemPropertiesAccessor.getBoolean("java.net.preferIPv4Stack", false);
        IPV6_ADDRESSES_PREFERRED = systemPropertiesAccessor.getBoolean("java.net.preferIPv6Addresses", false);
        final Logger logger = Loggers.getLogger(Nets.class);
        logger.trace("-Djava.net.preferIPv4Stack: {}", (Object)IPV4_PREFERRED);
        logger.trace("-Djava.net.preferIPv6Addresses: {}", (Object)IPV6_ADDRESSES_PREFERRED);
        String[] virtualNetworkInterfaces = Strings.split(systemPropertiesAccessor.getString("langx.virtual.network.interfaces", "virtualbox,kernel debug,ppp0,6to4,loopback,miniport,virbr,docker,veth,calic,br,pan, virtual"), ",");
        virtualInterfaces = Collects.asList(Collects.asSet(virtualNetworkInterfaces));
        byte[] LOCALHOST4_BYTES = new byte[]{127, 0, 0, 1};
        byte[] LOCALHOST6_BYTES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        Inet4Address localhost4 = null;
        try {
            localhost4 = (Inet4Address)InetAddress.getByAddress("localhost", LOCALHOST4_BYTES);
        }
        catch (Exception e) {
            Throwables.throwAsRuntimeException(e);
        }
        LOCALHOST4 = localhost4;
        Inet6Address localhost6 = null;
        try {
            localhost6 = (Inet6Address)InetAddress.getByAddress("localhost", LOCALHOST6_BYTES);
        }
        catch (Exception e) {
            Throwables.throwAsRuntimeException(e);
        }
        LOCALHOST6 = localhost6;
        ArrayList<NetworkInterface> ifaces = new ArrayList<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    NetworkInterface iface = interfaces.nextElement();
                    if (!Nets.addressesFromNetworkInterface(iface).hasMoreElements()) continue;
                    ifaces.add(iface);
                }
            }
        }
        catch (SocketException e) {
            logger.warn("Failed to retrieve the list of available network interfaces", (Throwable)e);
        }
        NetworkInterface loopbackIface = null;
        InetAddress loopbackAddr = null;
        block14: for (NetworkInterface iface : ifaces) {
            i = Nets.addressesFromNetworkInterface(iface);
            while (i.hasMoreElements()) {
                InetAddress addr = i.nextElement();
                if (!addr.isLoopbackAddress()) continue;
                loopbackIface = iface;
                loopbackAddr = addr;
                break block14;
            }
        }
        if (loopbackIface == null) {
            try {
                for (NetworkInterface iface : ifaces) {
                    if (!iface.isLoopback() || !(i = Nets.addressesFromNetworkInterface(iface)).hasMoreElements()) continue;
                    loopbackIface = iface;
                    loopbackAddr = i.nextElement();
                    break;
                }
                if (loopbackIface == null) {
                    logger.warn("Failed to find the loopback interface");
                }
            }
            catch (SocketException e) {
                logger.warn("Failed to find the loopback interface", (Throwable)e);
            }
        }
        if (loopbackIface != null) {
            logger.debug("Loopback interface: {} ({}, {})", new Object[]{loopbackIface.getName(), loopbackIface.getDisplayName(), loopbackAddr == null ? null : loopbackAddr.getHostAddress()});
        } else if (loopbackAddr == null) {
            try {
                if (NetworkInterface.getByInetAddress(LOCALHOST6) != null) {
                    logger.debug("Using hard-coded IPv6 localhost address: {}", (Object)localhost6);
                    loopbackAddr = localhost6;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (loopbackAddr == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)localhost4);
                    loopbackAddr = localhost4;
                }
            }
        }
        LOOPBACK_IF = loopbackIface;
        LOCALHOST = loopbackAddr;
        SOMAXCONN = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer run() {
                int somaxconn = Platform.isWindows ? 200 : 128;
                File file = new File("/proc/sys/net/core/somaxconn");
                BufferedReader in = null;
                try {
                    if (file.exists()) {
                        in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));
                        somaxconn = Integer.parseInt(in.readLine());
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: {}", (Object)file, (Object)somaxconn);
                        }
                    } else {
                        Integer tmp = null;
                        if (systemPropertiesAccessor.getBoolean("com.langx.net.somaxconn.trySysctl", false).booleanValue()) {
                            tmp = Nets.sysctlGetInt("kern.ipc.somaxconn");
                            if (tmp == null) {
                                tmp = Nets.sysctlGetInt("kern.ipc.soacceptqueue");
                                if (tmp != null) {
                                    somaxconn = tmp;
                                }
                            } else {
                                somaxconn = tmp;
                            }
                        }
                        if (tmp == null) {
                            logger.debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", (Object)file, (Object)somaxconn);
                        }
                    }
                }
                catch (Exception e) {
                    logger.debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", new Object[]{file, somaxconn, e});
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                return somaxconn;
            }
        });
        DOMAIN_PATTERN = Regexps.createRegexp("([a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]-*)*[a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]++(\\.([a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]-*)*[a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]++)*|\\[(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\]", 2);
        EMAIL_DOMAIN_PATTERN = Regexps.createRegexp("([a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]-*)*[a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]++(\\.([a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]-*)*[a-z\u0080-\uffff0-9!#$%&'*+/=?^_`{|}~]++)*|\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]|\\[IPv6:(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\]", 2);
        NUMERIC = Regexps.createRegexp("\\d+");
    }
}

