/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.net;

import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Objs;

public class NetworkAddress
implements Comparable<NetworkAddress> {
    private String host;
    private int port;
    private AddrMode addrMode;

    public NetworkAddress() {
    }

    public NetworkAddress(String host, int port) {
        this(host, port, AddrMode.HOST);
    }

    public NetworkAddress(String host, int port, AddrMode addrMode) {
        this.host = host;
        if (port > 0) {
            this.port = port;
        }
        this.addrMode = addrMode;
    }

    public AddrMode getAddrMode() {
        return this.addrMode;
    }

    public void setAddrMode(AddrMode addrMode) {
        this.addrMode = addrMode;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int compareTo(NetworkAddress o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkAddress that = (NetworkAddress)o;
        if (this.port != that.port) {
            return false;
        }
        return Objs.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objs.hash(this.host, this.port);
    }

    public String toString() {
        return this.show(ShowStyle.BSON);
    }

    public String show() {
        return this.show(ShowStyle.BSON);
    }

    public String show(ShowStyle style) {
        style = Objs.useValueIfEmpty(style, ShowStyle.BSON);
        switch (style) {
            case URL: {
                return this.port > 0 ? this.host + ":" + this.port : this.host;
            }
        }
        return StringTemplates.formatWithPlaceholder("{host: {}, port:{}, addrMode: {}}", new Object[]{this.host, this.port, this.addrMode});
    }

    public static enum ShowStyle {
        URL,
        BSON;

    }

    public static enum AddrMode {
        V4,
        V6,
        HOST;

    }
}

