/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.net;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.file.Files;
import com.jn.langx.util.jar.multiplelevel.MultipleLevelURLStreamHandler;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.net.URLConnections;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class URLs {
    private static final Map<String, String> URL_PREFIX_MAPPING = new HashMap<String, String>();
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String URL_PREFIX_FILE = "file://";
    public static final String URL_PREFIX_JAR = "jar:";
    public static final String URL_PREFIX_JAR_FILE = "jar:file:///";
    public static final String URL_PREFIX_FTP = "ftp://";
    public static final String URL_PREFIX_HTTP = "http://";
    public static final String URL_PREFIX_HTTPS = "https://";
    public static final String URL_PREFIX_MAIL = "mail:";
    public static final String URL_PREFIX_SMTP = "smtp://";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_WAR = "war";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String JAR_FILE_SUFFIX = ".jar";
    public static final String WAR_URL_SEPARATOR = "*/";
    private static final List<String> SECURITY_PROTOCOLS;

    private URLs() {
    }

    public static URL toURL(URI uri) {
        Preconditions.checkNotNull(uri);
        try {
            return uri.toURL();
        }
        catch (Exception ex) {
            Loggers.getLogger(URLs.class).warn("error url: {}", (Object)uri);
            return null;
        }
    }

    public static URL newURL(@NonNull String url) {
        Preconditions.checkNotNull(url);
        try {
            return new URL(url);
        }
        catch (Exception ex) {
            Loggers.getLogger(URLs.class).warn("error url: {}", (Object)url);
            return null;
        }
    }

    public static String getUrlPrefix(String protocol) {
        return URL_PREFIX_MAPPING.get(protocol);
    }

    public static boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(protocol);
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return protocol.equals(URL_PROTOCOL_JAR) && url.getPath().contains(JAR_URL_SEPARATOR);
    }

    public static boolean isMultipleLevelJarURL(URL url) {
        if (URLs.isJarURL(url)) {
            String path = url.getPath();
            return path.indexOf(JAR_URL_SEPARATOR) != path.lastIndexOf(JAR_URL_SEPARATOR);
        }
        return false;
    }

    public static File getFile(URL url) {
        if (URLs.isFileURL(url)) {
            return Files.newFile(url.getFile());
        }
        return null;
    }

    public static boolean exists(URL url) {
        if (url == null) {
            return false;
        }
        try {
            Object conn;
            HttpURLConnection httpCon;
            if (URLs.isFileURL(url)) {
                return Files.exists(URLs.getFile(url));
            }
            if (URLs.isJarURL(url) && URLs.isMultipleLevelJarURL(url)) {
                String urlString = url.toString();
                url = new URL(null, urlString, new MultipleLevelURLStreamHandler());
            }
            HttpURLConnection httpURLConnection = httpCon = (conn = URLs.openURL(url)) instanceof HttpURLConnection ? (HttpURLConnection)conn : null;
            if (httpCon != null) {
                int code = httpCon.getResponseCode();
                if (code == 200) {
                    return true;
                }
                if (code == 404) {
                    return false;
                }
            }
            if (URLConnections.getContentLengthLong(conn) > 0L) {
                return true;
            }
            if (URLConnections.getContentLength(conn) > 0) {
                return true;
            }
            if (httpCon != null) {
                httpCon.disconnect();
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getContentLength(URL url) {
        Preconditions.checkNotNull(url);
        try {
            if (URLs.isFileURL(url)) {
                File f = URLs.getFile(url);
                if (f == null) return -1L;
                return f.length();
            }
            if (URLs.isJarURL(url) && URLs.isMultipleLevelJarURL(url)) {
                String urlString = url.toString();
                url = new URL(null, urlString, new MultipleLevelURLStreamHandler());
            }
            URLConnection con = null;
            try {
                con = (URLConnection)URLs.openURL(url);
                long length = URLConnections.getContentLengthLong(con);
                if (length < 0L) {
                    length = URLConnections.getContentLength(con);
                }
                long l = length;
                return l;
            }
            catch (IOException ex) {
                long l2 = -1L;
                return l2;
            }
            finally {
                if (con != null) {
                    try {
                        IOs.close(con.getInputStream());
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (Exception ex2) {
            return -1L;
        }
    }

    public static InputStream getInputStream(URL url) {
        try {
            Object con = URLs.openURL(url);
            return ((URLConnection)con).getInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static <U extends URLConnection> U openURL(URL url) throws IOException {
        String protocol = url.getProtocol();
        if (SECURITY_PROTOCOLS.contains(protocol)) {
            return (U)url.openConnection();
        }
        throw new IOException(StringTemplates.formatWithPlaceholder("unsupported protocol: {}", url.toString()));
    }

    public static String getUserFromURI(URI uri) {
        int colon;
        String userInfo = uri.getUserInfo();
        if (userInfo == null && "domain".equals(uri.getScheme())) {
            String ssp = uri.getSchemeSpecificPart();
            int at = ssp.lastIndexOf(64);
            if (at == -1) {
                return null;
            }
            userInfo = ssp.substring(0, at);
        }
        if (userInfo != null && (colon = userInfo.indexOf(58)) != -1) {
            userInfo = userInfo.substring(0, colon);
        }
        return userInfo;
    }

    static {
        URL_PREFIX_MAPPING.put("http", URL_PREFIX_HTTP);
        URL_PREFIX_MAPPING.put("https", URL_PREFIX_HTTPS);
        URL_PREFIX_MAPPING.put("ftp", URL_PREFIX_FTP);
        URL_PREFIX_MAPPING.put(URL_PROTOCOL_JAR, URL_PREFIX_JAR);
        URL_PREFIX_MAPPING.put(URL_PROTOCOL_FILE, URL_PREFIX_FILE);
        URL_PREFIX_MAPPING.put("smtp", URL_PREFIX_SMTP);
        URL_PREFIX_MAPPING.put("mail", URL_PREFIX_MAIL);
        SECURITY_PROTOCOLS = Collects.newArrayList(URL_PROTOCOL_FILE, URL_PROTOCOL_JAR);
    }
}

