/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.net.idn;

import com.jn.langx.codec.StringCodec;
import com.jn.langx.util.net.idn.PunycodeException;

public class PunycodeCodec
implements StringCodec {
    static final int TMIN = 1;
    static final int TMAX = 26;
    static final int BASE = 36;
    static final int INITIAL_N = 128;
    static final int INITIAL_BIAS = 72;
    static final int DAMP = 700;
    static final int SKEW = 38;
    static final char DELIMITER = '-';

    @Override
    public String encode(String input) {
        int n = 128;
        int delta = 0;
        int bias = 72;
        StringBuilder output = new StringBuilder();
        int b = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!PunycodeCodec.isBasic(c)) continue;
            output.append(c);
            ++b;
        }
        if (b > 0) {
            output.append('-');
        }
        int h = b;
        while (h < input.length()) {
            int c;
            int m = Integer.MAX_VALUE;
            for (int i = 0; i < input.length(); ++i) {
                c = input.charAt(i);
                if (c < n || c >= m) continue;
                m = c;
            }
            if (m - n > (Integer.MAX_VALUE - delta) / (h + 1)) {
                throw new PunycodeException("Overflow.");
            }
            delta += (m - n) * (h + 1);
            n = m;
            for (int j = 0; j < input.length(); ++j) {
                int t;
                c = input.charAt(j);
                if (c < n && 0 == ++delta) {
                    throw new PunycodeException("Overflow.");
                }
                if (c != n) continue;
                int q = delta;
                int k = 36;
                while (q >= (t = k <= bias ? 1 : (k >= bias + 26 ? 26 : k - bias))) {
                    output.append((char)PunycodeCodec.digit2codepoint(t + (q - t) % (36 - t)));
                    q = (q - t) / (36 - t);
                    k += 36;
                }
                output.append((char)PunycodeCodec.digit2codepoint(q));
                bias = PunycodeCodec.adapt(delta, h + 1, h == b);
                delta = 0;
                ++h;
            }
            ++delta;
            ++n;
        }
        return output.toString();
    }

    @Override
    public String decode(String input) {
        int n = 128;
        int i = 0;
        int bias = 72;
        StringBuilder output = new StringBuilder();
        int d = input.lastIndexOf(45);
        if (d > 0) {
            for (int j = 0; j < d; ++j) {
                char c = input.charAt(j);
                if (!PunycodeCodec.isBasic(c)) {
                    throw new PunycodeException("Bad input.");
                }
                output.append(c);
            }
            ++d;
        } else {
            d = 0;
        }
        while (d < input.length()) {
            int oldi = i;
            int w = 1;
            int k = 36;
            while (true) {
                char c;
                int digit;
                if (d == input.length()) {
                    throw new PunycodeException("Bad input.");
                }
                if ((digit = PunycodeCodec.codepoint2digit(c = input.charAt(d++))) > (Integer.MAX_VALUE - i) / w) {
                    throw new PunycodeException("Overflow.");
                }
                i += digit * w;
                int t = k <= bias ? 1 : (k >= bias + 26 ? 26 : k - bias);
                if (digit < t) break;
                w *= 36 - t;
                k += 36;
            }
            bias = PunycodeCodec.adapt(i - oldi, output.length() + 1, oldi == 0);
            if (i / (output.length() + 1) > Integer.MAX_VALUE - n) {
                throw new PunycodeException("Overflow.");
            }
            n += i / (output.length() + 1);
            output.insert(i %= output.length() + 1, (char)n);
            ++i;
        }
        return output.toString();
    }

    public static int adapt(int delta, int numpoints, boolean first) {
        delta = first ? (delta /= 700) : (delta /= 2);
        delta += delta / numpoints;
        int k = 0;
        while (delta > 455) {
            delta /= 35;
            k += 36;
        }
        return k + 36 * delta / (delta + 38);
    }

    public static boolean isBasic(char c) {
        return c < '\u0080';
    }

    public static int digit2codepoint(int d) throws PunycodeException {
        if (d < 26) {
            return d + 97;
        }
        if (d < 36) {
            return d - 26 + 48;
        }
        throw new PunycodeException("Bad input.");
    }

    public static int codepoint2digit(int c) throws PunycodeException {
        if (c - 48 < 10) {
            return c - 48 + 26;
        }
        if (c - 97 < 26) {
            return c - 97;
        }
        throw new PunycodeException("Bad input.");
    }
}

