/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.os;

import com.jn.langx.util.Maths;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.io.Channels;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.os.OS;
import com.jn.langx.util.struct.Holder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;

class CpuCoreSensor {
    private static final String CPUS_ALLOWED = "Cpus_allowed:";
    private static final byte[] BITS = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};

    private CpuCoreSensor() {
    }

    public static int availableProcessors() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    return CpuCoreSensor.determineProcessors();
                }
            });
        }
        return CpuCoreSensor.determineProcessors();
    }

    private static int determineProcessors() {
        int fromJava = Runtime.getRuntime().availableProcessors();
        int fromProcFile = 0;
        if (!OS.isLinux()) {
            return fromJava;
        }
        try {
            fromProcFile = CpuCoreSensor.readCPUMask(new File("/proc/self/status"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fromProcFile > 0 ? Maths.min(fromJava, fromProcFile) : fromJava;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int readCPUMask(File file) throws IOException {
        int n;
        if (file == null || !file.exists()) {
            return -1;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            final Holder<Integer> countHolder = new Holder<Integer>(-1);
            Channels.readLines(stream, Charsets.US_ASCII, Functions.booleanPredicate2(true), new Consumer2<Integer, String>(){

                @Override
                public void accept(Integer index, String line) {
                    if (line.startsWith(CpuCoreSensor.CPUS_ALLOWED)) {
                        int start;
                        int count = 0;
                        for (int i = start = CpuCoreSensor.CPUS_ALLOWED.length(); i < line.length(); ++i) {
                            char ch = line.charAt(i);
                            if (ch >= '0' && ch <= '9') {
                                count += BITS[ch - 48];
                                continue;
                            }
                            if (ch >= 'a' && ch <= 'f') {
                                count += BITS[ch - 97 + 10];
                                continue;
                            }
                            if (ch < 'A' || ch > 'F') continue;
                            count += BITS[ch - 65 + 10];
                        }
                        countHolder.set(count);
                    }
                }
            }, new Predicate2<Integer, String>(){

                @Override
                public boolean test(Integer key, String value) {
                    return (Integer)countHolder.get() >= 0;
                }
            });
            n = countHolder.get();
        }
        catch (Throwable throwable) {
            IOs.close(stream);
            throw throwable;
        }
        IOs.close(stream);
        return n;
    }
}

