/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.os;

import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.enums.base.CommonEnum;
import com.jn.langx.util.enums.base.EnumDelegate;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.os.OsArchSeries;
import java.util.EnumSet;

public enum OsArch implements CommonEnum
{
    X86_64(2001, "x86_64", "64 \u4f4d x86 \u67b6\u6784", OsArchSeries.X86, 64, "x8664", "x86-64", "x64", "ia32e", "em64t"),
    X86_32(2002, "x86_32", "32 \u4f4d x86 \u67b6\u6784", OsArchSeries.X86, 32, "x86-32", "x86_32", "x32", "x86"),
    I686(2005, "i686", "32 \u4f4d x86 \u67b6\u6784", OsArchSeries.X86, 32, new String[0]),
    I386(2005, "i386", "32 \u4f4d x86 \u67b6\u6784", OsArchSeries.X86, 32, new String[0]),
    AMD_64(2006, "amd_64", "64 \u4f4d x86 \u67b6\u6784", OsArchSeries.X86, 64, "amd-64", "amd64"),
    IA_64(1001, "itanium_64", "64 \u4f4d Intel Itanium \u5904\u7406\u5668", OsArchSeries.IA, 64, "ia64", "ia-64", "ia_64", "itanium64", "itanium-64", "itanium_64"),
    IA_32(1001, "itanium_32", "32 \u4f4d Intel Itanium \u5904\u7406\u5668", OsArchSeries.IA, 32, "itanium32", "itanium-32", "itanium_32", "itanium", "ia64n"),
    ARM_64(3001, "arm_64", "64 \u4f4d ARM \u67b6\u6784", OsArchSeries.ARM, 64, "arm64", "arm_64", "arm-64"),
    ARM_32(3002, "arm_32", "32 \u4f4d ARM \u67b6\u6784", OsArchSeries.ARM, 32, "arm32", "arm-32", "arm"),
    AARCH_64(3003, "aarch_64", "64 \u4f4d ARM \u67b6\u6784", OsArchSeries.ARM, 64, "aarch64", "aarch-64"),
    PPCLE_64(4001, "ppcle_64", "64 \u4f4d PowerPC \u67b6\u6784", OsArchSeries.POWER, 64, "ppcle64", "ppc64le", "ppcle-64"),
    PPCLE_32(4002, "ppcle_32", "64 \u4f4d PowerPC \u67b6\u6784", OsArchSeries.POWER, 64, "ppcle32", "ppc32le", "ppcle-32", "ppcle"),
    PPC_64(4003, "ppc_64", "64 \u4f4d PowerPC \u67b6\u6784", OsArchSeries.POWER, 64, "ppc64", "ppc-64", "ppc_64"),
    PPC32(4004, "ppc_32", "32 \u4f4d PowerPC \u67b6\u6784", OsArchSeries.POWER, 32, "powerpc", "ppc32", "power", "ppc"),
    S390_64(5001, "s390_64", "64 \u4f4d IBM System z \u67b6\u6784", OsArchSeries.Z, 64, "s390x", "s390-64"),
    S390_32(5002, "s390", "32 \u4f4d IBM System z \u67b6\u6784", OsArchSeries.Z, 32, new String[0]),
    MIPSEL_64(6001, "mipsel_64", "64 \u4f4d MIPS \u67b6\u6784", OsArchSeries.MIPS, 64, "mipsel-64", "mips64el", "mipsel64"),
    MIPS_64(6002, "mips_64", "64 \u4f4d MIPS \u67b6\u6784", OsArchSeries.MIPS, 64, "mips64", "mips-64"),
    MIPSEL_32(6003, "mipsel_32", "32 \u4f4d MIPS \u67b6\u6784", OsArchSeries.MIPS, 32, "mipsel-32", "mips32el", "mipsel32", "mipsel"),
    MIPS_32(6004, "mips_32", "32 \u4f4d MIPS \u67b6\u6784", OsArchSeries.MIPS, 32, "mips"),
    SPARC_64(7001, "sparc_64", "64 \u4f4d SPARC \u67b6\u6784", OsArchSeries.SPARC, 64, "sparcv9_64", "sparcv9_64", "sparcv9", "sparc64", "sparc-64"),
    SPARC_32(7001, "sparc_32", "32 \u4f4d SPARC \u67b6\u6784", OsArchSeries.SPARC, 32, "sparc"),
    PA_RISC_32(8001, "pa_risc", "32 \u4f4d PA-RISC \u67b6\u6784", OsArchSeries.PA_RISC, 32, "pa-risc", "pa"),
    ALPHA_64(9001, "alpha_64", "64 \u4f4d Alpha \u67b6\u6784", OsArchSeries.ALPHA, 64, "alpha64", "alpha-64", "alpha"),
    LOONGARCH_64(10001, "loongarch_64", "64 \u4f4d\u9f99\u82af\u67b6\u6784", OsArchSeries.LOONGARCH, 64, "loongarch64", "loongarch-64"),
    LOONGARCH_32(10002, "loongarch_32", "32 \u4f4d\u9f99\u82af\u67b6\u6784", OsArchSeries.LOONGARCH, 32, "loongarch"),
    RISCV_64(11001, "riscv_64", "64 \u4f4dRISC-V\u67b6\u6784", OsArchSeries.RISC_V, 64, "riscv-64", "riscv64", "risc-v-64", "risc-v_64", "risc_v-64", "risc_v_64"),
    RISCV_128(11002, "riscv_128", "128 \u4f4dRISC-V\u67b6\u6784", OsArchSeries.RISC_V, 128, "riscv-128", "riscv128", "risc-v-128", "risc-v_128", "risc_v-128", "risc_v_128"),
    RISCV_32(11003, "riscv_32", "32 \u4f4dRISC-V\u67b6\u6784", OsArchSeries.RISC_V, 32, "riscv-32", "riscv32", "riscv", "risc-v-32", "risc-v_32", "risc-v", "risc_v-32", "risc_v_32", "risc_v"),
    SW_64(12001, "sw_64", "64\u4f4d\u795e\u5a01\u67b6\u6784", OsArchSeries.SW, 64, "sw64", "sw-64"),
    VAX_32(98001, "vax_32", "32 \u4f4d VAX \u67b6\u6784", OsArchSeries.VAX, 32, "vax"),
    SH_64(99001, "sh_64", "SuperH \u67b6\u6784", OsArchSeries.SH, 64, "sh-64", "sh");

    EnumDelegate delegate;
    private OsArchSeries series;
    private int bit;
    private String[] aliases;

    private OsArch(int code, String name, String displayName, OsArchSeries series, int bit, String ... aliases) {
        this.delegate = new EnumDelegate(code, name, displayName);
        this.series = series;
        this.bit = bit;
        this.aliases = aliases;
    }

    public int getBit() {
        return this.bit;
    }

    public boolean is64Bit() {
        return this.bit == 64;
    }

    public static OsArch findByName(String osArch) {
        final String theName = Strings.lowerCase(osArch);
        return Pipeline.of(EnumSet.allOf(OsArch.class)).findFirst(new Predicate<OsArch>(){

            @Override
            public boolean test(OsArch arch) {
                boolean c = Pipeline.of(new String[0]).add(arch.getName()).addAll(arch.aliases).anyMatch(new Predicate<String>(){

                    @Override
                    public boolean test(String alias) {
                        return Strings.contains(theName, alias, true);
                    }
                });
                return c;
            }
        });
    }

    public static boolean isArchCompatible(OsArchSeries osArchSeries, String osArch) {
        OsArch arch = OsArch.findByName(osArch);
        return arch != null && arch.series == osArchSeries;
    }

    public static boolean isX86Compatible(String osArch) {
        return OsArch.isArchCompatible(OsArchSeries.X86, osArch);
    }

    public static boolean isARMCompatible(String osArch) {
        return OsArch.isArchCompatible(OsArchSeries.ARM, osArch);
    }

    public static boolean isPowerCompatible(String osArch) {
        return OsArch.isArchCompatible(OsArchSeries.POWER, osArch);
    }

    @Override
    public int getCode() {
        return this.delegate.getCode();
    }

    @Override
    public String getDisplayText() {
        return this.delegate.getDisplayText();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }
}

