/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.os;

import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;
import com.jn.langx.util.SystemPropertys;
import com.jn.langx.util.io.file.Files;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.os.CpuCoreSensor;
import com.jn.langx.util.os.Docker;
import com.jn.langx.util.os.JVMCore;
import com.jn.langx.util.os.OS;
import com.jn.langx.util.os.OsArch;
import com.jn.langx.util.reflect.Reflects;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;

public class Platform {
    private static final String OSNAME = SystemPropertys.get("os.name", "").toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    public static final boolean isAndroid = Platform.isAndroid0();
    public static final int JAVA_VERSION_INT = Platform.javaVersion();
    public static int JVM_BITs = Platform.getJvmBits();
    public static final JVMCore JVM = Platform.getJvmImpl();
    public static final boolean isKaffeJVM = JVM == JVMCore.KAFFE;
    public static final boolean isWindows = Platform.isWindows0();
    public static final boolean isMaxOS = OS.isMaxOSX();
    public static final boolean isOSX = Platform.isOSX();
    private static final boolean IS_IVKVM_DOT_NET = Platform.isIkvmDotNet0();
    public static final boolean isGroovyAvailable = Platform.isGroovyAvailable0();
    public static final String processId = Platform.getProcessId0();
    private static final boolean IMAGE_CODE = System.getProperty("org.graalvm.nativeimage.imagecode") != null;
    private static final Map<Integer, Integer> classMajorVersionToJdkVersion = new LinkedHashMap<Integer, Integer>();
    public static final OsArch osArch;

    private Platform() {
    }

    private static JVMCore getJvmImpl() {
        JVMCore jvm = null;
        String vmName = System.getProperty("java.vm.name");
        if (isAndroid) {
            jvm = Strings.contains(vmName, JVMCore.DALVIK.getName(), true) ? JVMCore.DALVIK : JVMCore.ART;
        } else if (Strings.contains(vmName, JVMCore.HOTSPOT.getName(), true)) {
            jvm = JVMCore.HOTSPOT;
        } else if (Strings.contains(vmName, JVMCore.OPEN_J9.getName(), true) || Strings.contains(vmName, "IBM", true)) {
            jvm = JVMCore.OPEN_J9;
        } else if (Strings.contains(vmName, JVMCore.JROCKIT.getName(), true)) {
            jvm = JVMCore.JROCKIT;
        } else if (Strings.contains(vmName, JVMCore.KAFFE.getName(), true) || Platform.isKaffeJVM()) {
            jvm = JVMCore.KAFFE;
        }
        if (jvm == null) {
            jvm = JVMCore.HOTSPOT;
        }
        return jvm;
    }

    public static boolean inImageCode() {
        return IMAGE_CODE;
    }

    private static boolean isOSX() {
        return OSNAME.startsWith("macosx") || OSNAME.startsWith("osx");
    }

    private static boolean isWindows0() {
        return System.getProperty("os.name", "").toLowerCase(Locale.US).contains("win");
    }

    private static boolean isIkvmDotNet0() {
        String vmName = System.getProperty("java.vm.name", "").toUpperCase(Locale.US);
        return "IKVM.NET".equals(vmName);
    }

    private static boolean isAndroid0() {
        String vmName = System.getProperty("java.vm.name");
        boolean isAndroid = "Dalvik".equals(vmName);
        if (!isAndroid) {
            String runtime = System.getProperty("java.runtime.name");
            isAndroid = Strings.getEmptyIfNull(runtime).toLowerCase().contains("android");
        }
        if (isAndroid) {
            Logger logger = Loggers.getLogger(Platform.class);
            logger.debug("Platform: Android");
        }
        return isAndroid;
    }

    private static boolean isKaffeJVM() {
        try {
            Class.forName("kaffe.util.NotImplemented");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static int javaVersion() {
        int majorVersion = Platform.isAndroid0() ? 6 : Platform.majorVersionFromJavaSpecificationVersion();
        Loggers.getLogger(Platform.class).debug("Java version: {}", (Object)majorVersion);
        return majorVersion;
    }

    private static int majorVersionFromJavaSpecificationVersion() {
        String vm = System.getProperty("java.version");
        if (vm == null) {
            vm = System.getProperty("java.runtime.version");
        }
        if (vm == null) {
            vm = System.getProperty("java.specification.version", "1.6");
        }
        return Platform.majorVersion(vm);
    }

    private static int majorVersion(String javaVersion) {
        int index = Strings.indexOf((CharSequence)javaVersion, (CharSequence)"_", 0);
        if (index != -1) {
            javaVersion = javaVersion.substring(0, index);
        }
        String[] components = javaVersion.split("\\.");
        int[] version = new int[components.length];
        for (int i = 0; i < components.length; ++i) {
            try {
                version[i] = Integer.parseInt(components[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (version[0] == 1) {
            return version[1];
        }
        return version[0];
    }

    public static boolean is3VMOrGreater() {
        return JAVA_VERSION_INT >= 3;
    }

    public static boolean is4VMOrGreater() {
        return JAVA_VERSION_INT >= 4;
    }

    public static boolean is5VMOrGreater() {
        return JAVA_VERSION_INT >= 5;
    }

    public static boolean is6VMOrGreater() {
        return JAVA_VERSION_INT >= 6;
    }

    public static boolean is7VMOrGreater() {
        return JAVA_VERSION_INT >= 7;
    }

    public static boolean is8VMOrGreater() {
        return JAVA_VERSION_INT >= 8;
    }

    public static boolean is9VMOrGreater() {
        return JAVA_VERSION_INT >= 9;
    }

    public static boolean is10VMOrGreater() {
        return JAVA_VERSION_INT >= 10;
    }

    public static boolean is11VMOrGreater() {
        return JAVA_VERSION_INT >= 11;
    }

    public static boolean is12VMOrGreater() {
        return JAVA_VERSION_INT >= 12;
    }

    public static boolean is13VMOrGreater() {
        return JAVA_VERSION_INT >= 13;
    }

    public static boolean is15VMOrGreater() {
        return JAVA_VERSION_INT >= 15;
    }

    public static boolean is17VMOrGreater() {
        return JAVA_VERSION_INT >= 17;
    }

    public static boolean is21VMOrGreater() {
        return JAVA_VERSION_INT >= 21;
    }

    public static boolean isXXVMorGerater(int xx) {
        return JAVA_VERSION_INT >= xx;
    }

    public static int getJavaVersion(int classMajorVersion) {
        return classMajorVersionToJdkVersion.get(classMajorVersion);
    }

    public static File getJavaExecutable() {
        String javaHome = null;
        File result = null;
        try {
            javaHome = System.getProperty("java.home");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != javaHome) {
            try {
                File binDir = Files.newFile(javaHome, "bin");
                if (binDir.isDirectory() && binDir.canRead()) {
                    String exec;
                    String[] execs;
                    String[] stringArray = execs = new String[]{"java", "java.exe"};
                    int n = stringArray.length;
                    for (int i = 0; i < n && !(result = new File(binDir, exec = stringArray[i])).canRead(); ++i) {
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean isGroovyAvailable0() {
        ClassLoader loader = Platform.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            Class<?> bindingClass = loader.loadClass("groovy.lang.Binding");
            return bindingClass != null;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static String getProcessId0() {
        try {
            if (isAndroid) {
                Object runtimeMXBean = Reflects.getDeclaredMethod(Class.forName("java.lang.management.ManagementFactory"), "getRuntimeMXBean", new Class[0]).invoke(null, new Object[0]);
                return Reflects.getDeclaredMethod(Class.forName("java.lang.management.RuntimeMXBean"), "getName", new Class[0]).invoke(runtimeMXBean, new Object[0]).toString().split("@")[0];
            }
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            return runtimeMXBean.getName().split("@")[0];
        }
        catch (Exception ex) {
            if (isAndroid) {
                try {
                    return new File("/proc/self").getCanonicalFile().getName();
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }
    }

    public static boolean equals(byte[] bytes1, int startPos1, byte[] bytes2, int startPos2, int length) {
        int end = startPos1 + length;
        while (startPos1 < end) {
            if (bytes1[startPos1] != bytes2[startPos2]) {
                return false;
            }
            ++startPos1;
            ++startPos2;
        }
        return true;
    }

    public static String getTempDirectoryPath() {
        return SystemPropertys.getJavaIOTmpDir();
    }

    public static File getTempDirectory() {
        return Files.newFile(Platform.getTempDirectoryPath());
    }

    public static String getUserHomeDirectoryPath() {
        return SystemPropertys.getUserHome();
    }

    public static File getUserHomeDirectory() {
        return Files.newFile(Platform.getUserHomeDirectoryPath());
    }

    public static int cpuCore() {
        return CpuCoreSensor.availableProcessors();
    }

    public static boolean isInDockerEnv() {
        return Docker.isDocker();
    }

    public static long getTotalPhysicalMemory() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Object attribute = mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize");
            return (Long)attribute;
        }
        catch (Exception e) {
            Loggers.getLogger(Platform.class).error(e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    private static OsArch getCurrentOSArch() {
        String osarchString = SystemPropertys.getOSArch();
        return OsArch.findByName(osarchString);
    }

    private static int getJvmBits() {
        String dataModel = System.getProperty("sun.arch.data.model");
        if (Objs.isEmpty(dataModel) || Strings.equals("unknown", dataModel)) {
            return osArch.getBit();
        }
        try {
            return Integer.parseInt(dataModel);
        }
        catch (Throwable e) {
            return osArch.getBit();
        }
    }

    static {
        classMajorVersionToJdkVersion.put(45, 1);
        classMajorVersionToJdkVersion.put(46, 2);
        classMajorVersionToJdkVersion.put(47, 3);
        classMajorVersionToJdkVersion.put(48, 4);
        classMajorVersionToJdkVersion.put(49, 5);
        classMajorVersionToJdkVersion.put(50, 6);
        classMajorVersionToJdkVersion.put(51, 7);
        classMajorVersionToJdkVersion.put(52, 8);
        classMajorVersionToJdkVersion.put(53, 9);
        classMajorVersionToJdkVersion.put(54, 10);
        classMajorVersionToJdkVersion.put(55, 11);
        classMajorVersionToJdkVersion.put(56, 12);
        classMajorVersionToJdkVersion.put(57, 14);
        classMajorVersionToJdkVersion.put(58, 14);
        classMajorVersionToJdkVersion.put(59, 15);
        classMajorVersionToJdkVersion.put(60, 16);
        classMajorVersionToJdkVersion.put(61, 17);
        classMajorVersionToJdkVersion.put(62, 18);
        classMajorVersionToJdkVersion.put(63, 19);
        classMajorVersionToJdkVersion.put(64, 20);
        classMajorVersionToJdkVersion.put(65, 21);
        classMajorVersionToJdkVersion.put(66, 22);
        osArch = Platform.getCurrentOSArch();
    }
}

