/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.os;

import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Reflects;
import java.lang.reflect.Method;

public class Uptime {
    public static final int NOIMPL = -1;
    private static final Uptime INSTANCE = new Uptime();
    private Impl impl;

    public static Uptime getInstance() {
        return INSTANCE;
    }

    private Uptime() {
        try {
            this.impl = new DefaultImpl();
        }
        catch (UnsupportedOperationException e) {
            Loggers.getLogger(Uptime.class).error("Defaulting Uptime to NOIMPL due to {} {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            this.impl = null;
        }
    }

    public Impl getImpl() {
        return this.impl;
    }

    public void setImpl(Impl impl) {
        this.impl = impl;
    }

    public static long getUptime() {
        Uptime u = Uptime.getInstance();
        if (u.impl == null) {
            return -1L;
        }
        return u.impl.getUptime();
    }

    public static class DefaultImpl
    implements Impl {
        public Object mxBean;
        public Method uptimeMethod;

        public DefaultImpl() {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> mgmtFactory = Class.forName("java.lang.management.ManagementFactory", true, cl);
                Class<?> runtimeClass = Class.forName("java.lang.management.RuntimeMXBean", true, cl);
                Class[] noParams = new Class[]{};
                Method mxBeanMethod = Reflects.getAnyMethod(mgmtFactory, "getRuntimeMXBean", noParams);
                if (mxBeanMethod == null) {
                    throw new UnsupportedOperationException("method getRuntimeMXBean() not found");
                }
                this.mxBean = mxBeanMethod.invoke(mgmtFactory, new Object[0]);
                if (this.mxBean == null) {
                    throw new UnsupportedOperationException("getRuntimeMXBean() method returned null");
                }
                this.uptimeMethod = Reflects.getAnyMethod(runtimeClass, "getUptime", noParams);
                if (this.uptimeMethod == null) {
                    throw new UnsupportedOperationException("method getUptime() not found");
                }
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Implementation not available in this environment", e);
            }
        }

        @Override
        public long getUptime() {
            try {
                return (Long)this.uptimeMethod.invoke(this.mxBean, new Object[0]);
            }
            catch (Exception e) {
                return -1L;
            }
        }
    }

    public static interface Impl {
        public long getUptime();
    }
}

