/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.pagination;

import java.util.List;

public class PagingResult<E> {
    private int pageNo;
    private int pageSize;
    private long total;
    private List<E> items;

    public int getPageNo() {
        return this.pageNo;
    }

    public PagingResult<E> setPageNo(int pageNo) {
        this.pageNo = pageNo;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public PagingResult<E> setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public PagingResult<E> setTotal(long total) {
        this.total = total;
        return this;
    }

    public List<E> getItems() {
        return this.items;
    }

    public PagingResult<E> setItems(List<E> items) {
        this.items = items;
        return this;
    }

    public int getMaxPage() {
        return (int)this.getMaxPageCount(this.pageSize);
    }

    public long getMaxPageCount(int pageSize) {
        if (this.total < 0L) {
            return -1L;
        }
        if (this.total == 0L || this.pageSize == 0) {
            return 0L;
        }
        if (pageSize < 0) {
            return -1L;
        }
        return this.total / (long)this.pageSize + (long)(this.total % (long)this.pageSize == 0L ? 0 : 1);
    }
}

