/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.progress;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.event.EventPublisher;
import com.jn.langx.event.EventPublisherAware;
import com.jn.langx.event.local.SimpleEventPublisher;
import com.jn.langx.lifecycle.AbstractInitializable;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.registry.GenericRegistry;
import com.jn.langx.util.progress.ProgressEvent;
import com.jn.langx.util.progress.ProgressEventType;
import com.jn.langx.util.progress.ProgressSource;

public class ProgressTracer
extends AbstractInitializable
implements EventPublisherAware {
    @NonNull
    private EventPublisher eventPublisher;
    @NonNull
    private GenericRegistry<ProgressSource> tracing;

    @Override
    protected void doInit() throws InitializationException {
        if (this.eventPublisher == null) {
            this.setEventPublisher(new SimpleEventPublisher());
        }
        if (this.tracing == null) {
            this.setTracing(new GenericRegistry<ProgressSource>());
        }
    }

    public void begin(ProgressSource source) {
        if (!this.tracing.names().contains(source.getName())) {
            this.tracing.register(source);
        }
        ProgressEvent event = new ProgressEvent(ProgressEventType.START, source);
        this.eventPublisher.publish(event);
    }

    public void finish(ProgressSource source) {
        this.tracing.unregister(source.getName());
        ProgressEvent event = new ProgressEvent(ProgressEventType.FINISH, source);
        this.eventPublisher.publish(event);
    }

    public void updateProcess(ProgressSource source) {
        if (this.tracing.contains(source.getName())) {
            ProgressEvent event = new ProgressEvent(ProgressEventType.UPDATE, source);
            this.eventPublisher.publish(event);
        }
    }

    @Override
    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        this.eventPublisher = publisher;
    }

    public GenericRegistry<ProgressSource> getTracing() {
        return this.tracing;
    }

    public void setTracing(GenericRegistry<ProgressSource> sourceRegistry) {
        this.tracing = sourceRegistry;
    }
}

