/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.random;

import com.jn.langx.Delegatable;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.random.BytesRandom;
import com.jn.langx.util.random.IRandom;

public class CommonBytesRandom
implements BytesRandom,
Delegatable<IRandom> {
    private IRandom delegate;
    private int multiplier = 1;

    @Override
    public IRandom getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(IRandom delegate) {
        this.delegate = delegate;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int multiplier) {
        Preconditions.checkArgument(multiplier >= 1, "multiplier >= 1, actual: {}", multiplier);
        this.multiplier = multiplier;
    }

    @Override
    public byte[] get(Integer size) {
        byte[] dest = new byte[size * this.multiplier];
        this.get(dest);
        return dest;
    }

    @Override
    public void get(byte[] dest) {
        Preconditions.checkNotNullArgument(dest, "dest");
        this.delegate.nextBytes(dest);
    }
}

