/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.random;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.concurrent.threadlocal.GlobalThreadLocalMap;
import com.jn.langx.util.random.CommonBytesRandom;
import java.nio.ByteBuffer;

public class PooledBytesRandom
extends CommonBytesRandom {
    public static final int POOL_SIZE_MULTIPLIER = 128;
    private ByteBuffer pool;

    public PooledBytesRandom() {
        this(128);
    }

    public PooledBytesRandom(int multiplier) {
        this.setMultiplier(multiplier);
        this.setDelegate(GlobalThreadLocalMap.getRandom());
    }

    @Override
    public byte[] get(Integer size) {
        Preconditions.checkNotNullArgument(size, "size");
        return this.getRandomBytes(size);
    }

    private byte[] getRandomBytes(int bytesLength) {
        boolean reGenBytes = false;
        if (this.pool == null || this.pool.capacity() < bytesLength) {
            this.pool = ByteBuffer.allocate(bytesLength * this.getMultiplier());
            reGenBytes = true;
        } else if (this.pool.position() + bytesLength > this.pool.limit()) {
            reGenBytes = true;
        }
        if (reGenBytes) {
            this.get(this.pool.array());
            this.pool = ByteBuffer.wrap(this.pool.array());
        }
        byte[] ret = new byte[bytesLength];
        this.pool.get(ret);
        return ret;
    }
}

