/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.random;

import com.jn.langx.security.crypto.key.SecureRandoms;
import com.jn.langx.text.StrTokenizer;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.id.Nanoids;
import com.jn.langx.util.random.IRandom;
import com.jn.langx.util.random.RandomProxy;
import com.jn.langx.util.struct.Pair;
import java.util.List;
import java.util.Random;

public class Randoms {
    public static IRandom of(Random random) {
        return new RandomProxy<Random>(random);
    }

    public static IRandom ofSecure() {
        return Randoms.of(SecureRandoms.getDefault());
    }

    public static String randomString() {
        return Randoms.randomString("361E6D51-FAEC-444A-9079-341386DA8E2E");
    }

    public static String randomString(String pattern) {
        return Randoms.randomString("useandom26T198340PX75pxJACKVERYMINDBUSHWOLFGQZbfghjklqvwyzrict", pattern);
    }

    public static String randomString(String alphabet, String pattern) {
        return Randoms.randomString(alphabet, pattern, "-");
    }

    public static String randomString(String alphabet, String pattern, final String separator) {
        boolean hasSeparator = Strings.isNotEmpty(separator);
        if (!hasSeparator) {
            return Randoms.randomString(alphabet, pattern.length());
        }
        List tokens = new StrTokenizer(pattern, true, false, -1, separator).tokenize();
        List<Pair<String, Boolean>> segments = Pipeline.of(tokens).map(new Function<String, Pair<String, Boolean>>(){

            @Override
            public Pair<String, Boolean> apply(String token) {
                return new Pair<String, Boolean>(token, Strings.equals(separator, token));
            }
        }).asList();
        int expectedLength = Pipeline.of(segments).filter(new Predicate<Pair<String, Boolean>>(){

            @Override
            public boolean test(Pair<String, Boolean> segment) {
                return segment.getValue() == false;
            }
        }).map(new Function<Pair<String, Boolean>, Integer>(){

            @Override
            public Integer apply(Pair<String, Boolean> segment) {
                return segment.getKey().length();
            }
        }).sum().intValue();
        String str = Randoms.randomString(alphabet, expectedLength);
        int offset = 0;
        StringBuilder builder = new StringBuilder();
        for (Pair<String, Boolean> segment : segments) {
            if (segment.getValue().booleanValue()) {
                builder.append(separator);
                continue;
            }
            int segmentLength = segment.getKey().length();
            int endIndex = offset + segmentLength;
            builder.append(Strings.substring(str, offset, endIndex));
            offset = endIndex;
        }
        return builder.toString();
    }

    public static String randomString(String alphabet, int length) {
        return Nanoids.nanoid(alphabet, length);
    }
}

