/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.ranges;

import com.jn.langx.util.ranges.Range;

public class CommonRange<T extends Comparable<T>>
extends Range<T> {
    public CommonRange(T start, T end) {
        super(start, end);
    }

    @Override
    public boolean contains(T value) {
        int delta;
        if (this.isEmpty()) {
            return value == null;
        }
        Comparable start = (Comparable)this.getStart();
        if (start != null && (delta = start.compareTo(value)) > 0) {
            return false;
        }
        Comparable end = (Comparable)this.getEndInclusive();
        if (end != null) {
            int delta2 = end.compareTo(value);
            return delta2 >= 0;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.getStart() == null && this.getEndInclusive() == null;
    }
}

