/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.reflect;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.comparator.ComparableComparator;
import com.jn.langx.util.comparator.DelegatableComparator;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.type.Primitives;
import java.lang.reflect.Field;
import java.util.Comparator;

public class FieldComparator<V>
implements DelegatableComparator<V> {
    private Field field;
    private Comparator<V> delegate;

    public FieldComparator(@NonNull Field field, @Nullable Comparator<V> fieldComparator) {
        Class<?> fieldClass;
        Preconditions.checkNotNull(field);
        this.field = field;
        if (fieldComparator == null && Reflects.isSubClassOrEquals(Comparable.class, Primitives.wrap(fieldClass = field.getType()))) {
            fieldComparator = new ComparableComparator<V>();
        }
        this.setDelegate(fieldComparator);
    }

    public FieldComparator(@NonNull Class clazz, @NonNull String fieldName, @Nullable Comparator fieldComparator) {
        this(Reflects.getAnyField(clazz, fieldName), fieldComparator);
    }

    @Override
    public int compare(V o1, V o2) {
        Object v1 = Reflects.getFieldValue(this.field, o1, true, false);
        Object v2 = Reflects.getFieldValue(this.field, o2, true, false);
        return this.delegate.compare(v1, v2);
    }

    @Override
    public Comparator<V> getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@NonNull Comparator<V> delegate) {
        this.delegate = delegate;
    }
}

