/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.reflect;

import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.reflect.Reflects;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Modifiers {
    static final int MANDATED = 32768;
    static final int SYNTHETIC = 4096;
    private static final Set<Integer> supportedModifiers = new HashSet<Integer>(Collects.asList(1024, 16, 512, 256, 1, 2, 4, 8, 32, 2048, 128, 64, 32768, 4096));

    public static boolean isSupportedModifier(int modifier) {
        return supportedModifiers.contains(modifier);
    }

    public static int modifiers(Member member) {
        return member.getModifiers();
    }

    public static boolean hasModifier(int modifiers, int modifier) {
        if (!Modifiers.isSupportedModifier(modifier)) {
            throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("Unsupported modifier: {}", modifier));
        }
        return (modifiers & modifier) != 0;
    }

    public static boolean hasModifier(Class clazz, int modifier) {
        return Modifiers.hasModifier(clazz.getModifiers(), modifier);
    }

    public static boolean hasModifier(Member member, int modifier) {
        return Modifiers.hasModifier(Modifiers.modifiers(member), modifier);
    }

    public static boolean isAbstract(Class clazz) {
        return Modifiers.hasModifier(clazz, 1024);
    }

    public static boolean isAbstract(Member member) {
        return Modifiers.hasModifier(member, 1024);
    }

    public static boolean isFinal(Class clazz) {
        return Modifiers.hasModifier(clazz, 16);
    }

    public static boolean isFinal(Member member) {
        return Modifiers.hasModifier(member, 16);
    }

    public static boolean isInterface(Class clazz) {
        return clazz.isInterface();
    }

    public static boolean isInterface(Member member) {
        return Modifiers.hasModifier(member, 512);
    }

    public static boolean isNative(Class clazz) {
        return Modifiers.hasModifier(clazz, 256);
    }

    public static boolean isNative(Member member) {
        return Modifiers.hasModifier(member, 256);
    }

    public static boolean isPublic(Class clazz) {
        return Modifiers.hasModifier(clazz, 1);
    }

    public static boolean isPublic(Member member) {
        return Modifiers.hasModifier(member, 1);
    }

    public static boolean isPrivate(Class clazz) {
        return Modifiers.hasModifier(clazz, 2);
    }

    public static boolean isPrivate(Member member) {
        return Modifiers.hasModifier(member, 2);
    }

    public static boolean isProtected(Class clazz) {
        return Modifiers.hasModifier(clazz, 4);
    }

    public static boolean isProtected(Member member) {
        return Modifiers.hasModifier(member, 4);
    }

    public static boolean isStatic(Class clazz) {
        return Modifiers.hasModifier(clazz, 8);
    }

    public static boolean isStatic(Member member) {
        return Modifiers.hasModifier(member, 8);
    }

    public static boolean isSynchronized(Member member) {
        return Modifiers.hasModifier(member, 32);
    }

    public static boolean isStrict(Member member) {
        return Modifiers.hasModifier(member, 2048);
    }

    public static boolean isTransient(Member member) {
        return Modifiers.hasModifier(member, 128);
    }

    public static boolean isVolatile(Member member) {
        return Modifiers.hasModifier(member, 64);
    }

    public static boolean isMandated(int mod) {
        return (mod & 0x8000) != 0;
    }

    public static boolean isMandated(Class clazz) {
        return Modifiers.hasModifier(clazz, 32768);
    }

    public static boolean isMandated(Member member) {
        return Modifiers.hasModifier(member, 32768);
    }

    public static boolean isSynthetic(int mod) {
        return (mod & 0x1000) != 0;
    }

    public static boolean isSynthetic(Class clazz) {
        return Modifiers.hasModifier(clazz, 4096);
    }

    public static boolean isSynthetic(Member member) {
        return Modifiers.hasModifier(member, 4096);
    }

    private Modifiers() {
    }

    static {
        Collection<Field> fields = Reflects.getAllPublicFields(Modifier.class, true);
        fields = Collects.filter(fields, new Predicate<Field>(){

            @Override
            public boolean test(Field field) {
                return Modifier.isPublic(field.getModifiers()) && Modifier.isStatic(field.getModifiers());
            }
        });
        Collection<Integer> supportedModifiersInModifierClass = Collects.map(fields, new Function<Field, Integer>(){

            @Override
            public Integer apply(Field field) {
                try {
                    return (Integer)Reflects.getFieldValue(field, Modifier.class, true, false);
                }
                catch (Throwable ex) {
                    return 1;
                }
            }
        });
        supportedModifiers.addAll(supportedModifiersInModifierClass);
    }
}

