/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.reflect;

import com.jn.langx.annotation.Name;
import com.jn.langx.annotation.Singleton;
import com.jn.langx.registry.Registry;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.parameter.ConstructorParameter;
import com.jn.langx.util.reflect.parameter.ConstructorParameterSupplier;
import com.jn.langx.util.reflect.parameter.MethodParameter;
import com.jn.langx.util.reflect.parameter.MethodParameterSupplier;
import com.jn.langx.util.reflect.parameter.ParameterMeta;
import com.jn.langx.util.reflect.parameter.ParameterSupplier;
import com.jn.langx.util.spi.CommonServiceProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

@Singleton
public class ParameterServiceRegistry
implements Registry<String, ParameterSupplier> {
    private static volatile ParameterServiceRegistry INSTANCE;
    private static final MethodParameterSupplier methodParameterSupplier;
    private static final ConstructorParameterSupplier constructorParameterSupplier;
    private static final Map<String, MethodParameterSupplier> methodParameterSupplierRegistry;
    private static final Map<String, ConstructorParameterSupplier> constructorParameterSupplierRegistry;
    public static final String JAVA_6_SUPPLIER_NAME = "langx_java6";
    public static final String JAVA_8_SUPPLIER_NAME = "langx_java8";

    private ParameterServiceRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParameterServiceRegistry getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ParameterServiceRegistry> clazz = ParameterServiceRegistry.class;
        synchronized (ParameterServiceRegistry.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ParameterServiceRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static void loadMethodParameterSuppliers() {
        Collects.forEach(CommonServiceProvider.loadService(MethodParameterSupplier.class), new Consumer<MethodParameterSupplier>(){

            @Override
            public void accept(MethodParameterSupplier supplier) {
                if (supplier.getClass().getPackage().getName().startsWith("com.jn.langx.")) {
                    ParameterServiceRegistry.registerInternal(supplier);
                }
            }
        });
    }

    private static void loadConstructorParameterSuppliers() {
        ServiceLoader<ConstructorParameterSupplier> loader = ServiceLoader.load(ConstructorParameterSupplier.class);
        Collects.forEach(loader, new Consumer<ConstructorParameterSupplier>(){

            @Override
            public void accept(ConstructorParameterSupplier supplier) {
                if (supplier.getClass().getPackage().getName().startsWith("com.jn.langx.")) {
                    ParameterServiceRegistry.registerInternal(supplier);
                }
            }
        });
    }

    public List<MethodParameter> getMethodParameters(Method method) {
        return this.getMethodParameters(null, method);
    }

    public List<MethodParameter> getMethodParameters(final String supplierName, final Method method) {
        Preconditions.checkNotNull(method);
        int count = method.getParameterTypes().length;
        final ArrayList<MethodParameter> parameters = Collects.newArrayList();
        if (count > 0) {
            Collects.forEach(Arrs.range(count), new Consumer<Integer>(){

                @Override
                public void accept(Integer index) {
                    parameters.add(ParameterServiceRegistry.this.getMethodParameter(supplierName, method, index));
                }
            });
        }
        return parameters;
    }

    public MethodParameter getMethodParameter(Method method, int index) {
        return this.getMethodParameter(null, method, index);
    }

    public MethodParameter getMethodParameter(String supplierName, Method method, int index) {
        return this.getMethodParameter(supplierName, "arg" + index, 0, method, index);
    }

    public MethodParameter getMethodParameter(String name, int modifiers, Method method, int index) {
        return this.getMethodParameter(null, name, modifiers, method, index);
    }

    public MethodParameter getMethodParameter(String supplierName, String name, int modifiers, Method method, int index) {
        return (MethodParameter)this.findMethodParameterSupplier(supplierName, true).get(new ParameterMeta(name, modifiers, method, index));
    }

    public List<ConstructorParameter> getConstructorParameters(Constructor constructor) {
        return this.getConstructorParameters(null, constructor);
    }

    public List<ConstructorParameter> getConstructorParameters(final String supplierName, final Constructor constructor) {
        Preconditions.checkNotNull(constructor);
        int count = constructor.getParameterTypes().length;
        final ArrayList<ConstructorParameter> parameters = Collects.newArrayList();
        if (count > 0) {
            Collects.forEach(Arrs.range(count), new Consumer<Integer>(){

                @Override
                public void accept(Integer index) {
                    parameters.add(ParameterServiceRegistry.this.getConstructorParameter(supplierName, constructor, index));
                }
            });
        }
        return parameters;
    }

    public ConstructorParameter getConstructorParameter(Constructor constructor, int index) {
        return this.getConstructorParameter(null, constructor, index);
    }

    public ConstructorParameter getConstructorParameter(String supplierName, Constructor constructor, int index) {
        return this.getConstructorParameter(supplierName, "arg" + index, 0, constructor, index);
    }

    public ConstructorParameter getConstructorParameter(String name, int modifiers, Constructor constructor, int index) {
        return this.getConstructorParameter(null, name, modifiers, constructor, index);
    }

    public ConstructorParameter getConstructorParameter(String supplierName, String name, int modifiers, Constructor constructor, int index) {
        return (ConstructorParameter)this.findConstructorParameterSupplier(supplierName, true).get(new ParameterMeta(name, modifiers, constructor, index));
    }

    public MethodParameterSupplier getDefaultMethodParameterSupplier() {
        return methodParameterSupplier;
    }

    public ConstructorParameterSupplier getDefaultConstructorParameterSupplier() {
        return constructorParameterSupplier;
    }

    public MethodParameterSupplier findMethodParameterSupplier(String name) {
        return this.findMethodParameterSupplier(name, true);
    }

    public MethodParameterSupplier findMethodParameterSupplier(String name, boolean useDefaultIfNotFound) {
        MethodParameterSupplier supplier = methodParameterSupplierRegistry.get(name);
        if (supplier == null && useDefaultIfNotFound) {
            return this.getDefaultMethodParameterSupplier();
        }
        return supplier;
    }

    public ConstructorParameterSupplier findConstructorParameterSupplier(String name) {
        return this.findConstructorParameterSupplier(name, true);
    }

    public ConstructorParameterSupplier findConstructorParameterSupplier(String name, boolean useDefaultIfNotFound) {
        ConstructorParameterSupplier supplier = constructorParameterSupplierRegistry.get(name);
        if (supplier == null && useDefaultIfNotFound) {
            return this.getDefaultConstructorParameterSupplier();
        }
        return supplier;
    }

    @Override
    public void register(String name, MethodParameterSupplier supplier) {
        if (methodParameterSupplierRegistry.get(name) == null) {
            methodParameterSupplierRegistry.put(name, supplier);
        }
    }

    @Override
    public void register(String name, ConstructorParameterSupplier supplier) {
        if (constructorParameterSupplierRegistry.get(name) == null) {
            constructorParameterSupplierRegistry.put(name, supplier);
        }
    }

    private static void registerInternal(ConstructorParameterSupplier supplier) {
        Class<?> clazz = supplier.getClass();
        String name = Reflects.getFQNClassName(clazz);
        constructorParameterSupplierRegistry.put(name, supplier);
        if (Reflects.hasAnnotation(clazz, Name.class)) {
            Name nameAnno = Reflects.getAnnotation(clazz, Name.class);
            name = nameAnno.value();
            constructorParameterSupplierRegistry.put(name, supplier);
        }
    }

    private static void registerInternal(MethodParameterSupplier supplier) {
        Class<?> clazz = supplier.getClass();
        String name = Reflects.getFQNClassName(clazz);
        methodParameterSupplierRegistry.put(name, supplier);
        if (Reflects.hasAnnotation(clazz, Name.class)) {
            Name nameAnno = Reflects.getAnnotation(clazz, Name.class);
            name = nameAnno.value();
            methodParameterSupplierRegistry.put(name, supplier);
        }
    }

    @Override
    public void register(ParameterSupplier parameterSupplier) {
        if (parameterSupplier != null) {
            if (parameterSupplier instanceof MethodParameterSupplier) {
                ParameterServiceRegistry.registerInternal((MethodParameterSupplier)parameterSupplier);
            } else if (parameterSupplier instanceof ConstructorParameterSupplier) {
                ParameterServiceRegistry.registerInternal((ConstructorParameterSupplier)parameterSupplier);
            }
        }
    }

    @Override
    public void register(String name, ParameterSupplier parameterSupplier) {
        if (parameterSupplier != null) {
            if (parameterSupplier instanceof MethodParameterSupplier) {
                this.register(name, (MethodParameterSupplier)parameterSupplier);
            } else if (parameterSupplier instanceof ConstructorParameterSupplier) {
                this.register(name, (ConstructorParameterSupplier)parameterSupplier);
            }
        }
    }

    @Override
    public void unregister(String key) {
        methodParameterSupplierRegistry.remove(key);
        constructorParameterSupplierRegistry.remove(key);
    }

    @Override
    public boolean contains(String key) {
        return methodParameterSupplierRegistry.containsKey(key) || constructorParameterSupplierRegistry.containsKey(key);
    }

    @Override
    public ParameterSupplier get(String input) {
        return null;
    }

    static {
        methodParameterSupplierRegistry = new HashMap<String, MethodParameterSupplier>();
        constructorParameterSupplierRegistry = new HashMap<String, ConstructorParameterSupplier>();
        boolean JDK_PARAMETER_FOUND = false;
        try {
            Class.forName("java.lang.reflect.Parameter");
            JDK_PARAMETER_FOUND = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ParameterServiceRegistry.loadMethodParameterSuppliers();
        String defaultName = JDK_PARAMETER_FOUND ? JAVA_8_SUPPLIER_NAME : JAVA_6_SUPPLIER_NAME;
        MethodParameterSupplier defaultMethodParameterSupplier = methodParameterSupplierRegistry.get(defaultName);
        if (defaultMethodParameterSupplier == null && JDK_PARAMETER_FOUND) {
            defaultMethodParameterSupplier = methodParameterSupplierRegistry.get(JAVA_6_SUPPLIER_NAME);
        }
        methodParameterSupplier = defaultMethodParameterSupplier;
        ParameterServiceRegistry.loadConstructorParameterSuppliers();
        ConstructorParameterSupplier defaultConstructorParameterSupplier = constructorParameterSupplierRegistry.get(defaultName);
        if (defaultConstructorParameterSupplier == null && JDK_PARAMETER_FOUND) {
            defaultConstructorParameterSupplier = constructorParameterSupplierRegistry.get(JAVA_6_SUPPLIER_NAME);
        }
        constructorParameterSupplier = defaultConstructorParameterSupplier;
    }
}

