/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.reflect.classparse;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.reflect.Modifiers;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.classparse.ClassParser;
import com.jn.langx.util.reflect.classparse.FieldInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FieldSetterAndGetterClassParser<F extends FieldInfo>
implements ClassParser<Map<String, F>> {
    private boolean hierachial = false;
    private boolean zeroParameterConstructor = false;

    public boolean isHierachial() {
        return this.hierachial;
    }

    public void setHierachial(boolean hierachial) {
        this.hierachial = hierachial;
    }

    public boolean isZeroParameterConstructor() {
        return this.zeroParameterConstructor;
    }

    public void setZeroParameterConstructor(boolean zeroParameterConstructor) {
        this.zeroParameterConstructor = zeroParameterConstructor;
    }

    private boolean isParsable(Class clazz) {
        return clazz != null && clazz != Object.class && !clazz.isInterface() && !clazz.isArray() && !clazz.isAnnotation() && !clazz.isPrimitive();
    }

    @Override
    public Map<String, F> parse(Class clazz) {
        return this.parse0(clazz, this.zeroParameterConstructor);
    }

    private Map<String, F> parse0(final Class clazz, boolean checkZeroParameterConstructor) {
        Class parentClass;
        Preconditions.checkNotNull(clazz);
        Preconditions.checkTrue(!clazz.isInterface());
        Preconditions.checkTrue(Object.class != clazz);
        final HashMap fieldInfoMap = new HashMap();
        Collection<Field> fields = Reflects.getAllDeclaredFields(clazz, true);
        Collects.forEach(fields, new Consumer<Field>(){

            @Override
            public void accept(Field field) {
                Object fieldInfo = FieldSetterAndGetterClassParser.this.parseField(clazz, field);
                if (fieldInfo != null) {
                    fieldInfoMap.put(field.getName(), fieldInfo);
                }
            }
        });
        if (this.hierachial && this.isParsable(parentClass = clazz.getSuperclass())) {
            Collects.forEach(this.parse0(parentClass, false), new Consumer2<String, F>(){

                @Override
                public void accept(String fieldName, F fieldInfo) {
                    if (!fieldInfoMap.containsKey(fieldName)) {
                        fieldInfoMap.put(fieldName, fieldInfo);
                    }
                }
            });
        }
        return fieldInfoMap;
    }

    protected F parseField(Class clazz, Field field) {
        if (Modifiers.isStatic(field)) {
            return null;
        }
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.setField(field);
        Class<?> fieldType = field.getType();
        Method setter = Reflects.getSetter(clazz, field.getName(), fieldType);
        Method getter = Reflects.getGetter(clazz, field.getName());
        fieldInfo.setGetter(getter);
        fieldInfo.setSetter(setter);
        return (F)fieldInfo;
    }
}

