/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.reflect.parameter;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.reflect.Modifiers;
import com.jn.langx.util.reflect.parameter.MethodParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Java6MethodParameter
implements MethodParameter {
    private final String name;
    private final int modifiers;
    private final int index;
    private final Method method;
    private Type parameterTypeCache;
    private volatile transient Class<?> parameterClassCache = null;
    private transient Map<Class<? extends Annotation>, Annotation> declaredAnnotations;

    Java6MethodParameter(String name, int modifiers, Method method, int index) {
        this.name = name;
        this.modifiers = modifiers;
        this.method = method;
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Java6MethodParameter) {
            Java6MethodParameter other = (Java6MethodParameter)obj;
            return other.method.equals(this.method) && other.index == this.index;
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode() ^ this.index;
    }

    @Override
    public boolean isNamePresent() {
        return this.name != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Class<?> type = this.getType();
        String typename = ((Object)type).toString();
        sb.append(Modifier.toString(this.getModifiers()));
        if (0 != this.modifiers) {
            sb.append(' ');
        }
        if (this.isVarArgs()) {
            sb.append(typename.replaceFirst("\\[]$", "..."));
        } else {
            sb.append(typename);
        }
        sb.append(' ');
        sb.append(this.getName());
        return sb.toString();
    }

    @Override
    public Method getDeclaringExecutable() {
        return this.method;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getName() {
        if (this.name == null || this.name.equals("")) {
            return "arg" + this.index;
        }
        return this.name;
    }

    String getRealName() {
        return this.name;
    }

    @Override
    public Type getParameterizedType() {
        Type tmp = this.parameterTypeCache;
        if (null == tmp) {
            this.parameterTypeCache = tmp = this.method.getGenericParameterTypes()[this.index];
        }
        return tmp;
    }

    @Override
    public Class<?> getType() {
        Class<?> tmp = this.parameterClassCache;
        if (null == tmp) {
            this.parameterClassCache = tmp = this.method.getParameterTypes()[this.index];
        }
        return tmp;
    }

    @Override
    public boolean isImplicit() {
        return Modifiers.isMandated(this.getModifiers());
    }

    @Override
    public boolean isSynthetic() {
        return Modifiers.isSynthetic(this.getModifiers());
    }

    @Override
    public boolean isVarArgs() {
        return this.method.isVarArgs() && this.index == this.method.getParameterTypes().length - 1;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Preconditions.checkNotNull(annotationClass);
        return (T)((Annotation)annotationClass.cast(this.declaredAnnotations().get(annotationClass)));
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        Annotation annotation = this.declaredAnnotations().get(annotationClass);
        return annotation != null;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.method.getParameterAnnotations()[this.index];
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.getAnnotationsByType(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        Annotation annotation = this.declaredAnnotations().get(annotationClass);
        ArrayList<Annotation> annotations = Collects.newArrayList();
        if (annotation != null) {
            annotations.add(annotation);
        }
        return (Annotation[])Collects.asArray(annotations, annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    private synchronized Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        if (null == this.declaredAnnotations) {
            Annotation[] ann;
            this.declaredAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
            for (Annotation annotation : ann = this.getDeclaredAnnotations()) {
                this.declaredAnnotations.put(annotation.annotationType(), annotation);
            }
        }
        return this.declaredAnnotations;
    }
}

