/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.reflect.reference;

import com.jn.langx.util.reflect.reference.HashedSoftwareReference;
import com.jn.langx.util.reflect.reference.HashedStrongReference;
import com.jn.langx.util.reflect.reference.HashedWeakReference;
import com.jn.langx.util.reflect.reference.ReferenceType;
import java.lang.ref.ReferenceQueue;

public class References {
    private References() {
    }

    public static <V> Object newReference(V value, ReferenceType referenceType) {
        return References.newReference(null, value, referenceType, null, false);
    }

    public static <V> Object newReference(V value, ReferenceType referenceType, boolean wrappedWhenStrong) {
        return References.newReference(null, value, referenceType, null, wrappedWhenStrong);
    }

    public static <V> Object newReference(V value, ReferenceType referenceType, ReferenceQueue<Object> refQueue, boolean wrappedWhenStrong) {
        return References.newReference(null, value, referenceType, refQueue, wrappedWhenStrong);
    }

    public static <V> Object newReference(Integer hash, V value, ReferenceType referenceType, ReferenceQueue<Object> refQueue, boolean wrappedWhenStrong) {
        if (referenceType == ReferenceType.WEAK) {
            return new HashedWeakReference<Object>(value, refQueue, hash);
        }
        if (referenceType == ReferenceType.SOFT) {
            return new HashedSoftwareReference<Object>(value, refQueue, hash);
        }
        if (wrappedWhenStrong) {
            return new HashedStrongReference<V>(value, hash);
        }
        return value;
    }
}

