/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.reflect.type;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.reflect.type.Types;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;

public class ParameterizedTypeImpl
implements ParameterizedType {
    private final Type ownerType;
    private final Type rawType;
    private final Type[] typeArguments;
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    public ParameterizedTypeImpl(Type ownerType, Type rawType, Type ... typeArguments) {
        if (rawType instanceof Class) {
            Class rawTypeAsClass = (Class)rawType;
            boolean isStaticOrTopLevelClass = Modifier.isStatic(rawTypeAsClass.getModifiers()) || rawTypeAsClass.getEnclosingClass() == null;
            ParameterizedTypeImpl.checkArgument(ownerType != null || isStaticOrTopLevelClass);
        }
        this.ownerType = ownerType == null ? null : ParameterizedTypeImpl.canonicalize(ownerType);
        this.rawType = ParameterizedTypeImpl.canonicalize(rawType);
        this.typeArguments = (Type[])typeArguments.clone();
        int length = this.typeArguments.length;
        for (int t = 0; t < length; ++t) {
            Preconditions.checkNotNull(this.typeArguments[t]);
            ParameterizedTypeImpl.checkNotPrimitive(this.typeArguments[t]);
            this.typeArguments[t] = ParameterizedTypeImpl.canonicalize(this.typeArguments[t]);
        }
    }

    static void checkNotPrimitive(Type type) {
        ParameterizedTypeImpl.checkArgument(!(type instanceof Class) || !((Class)type).isPrimitive());
    }

    public static Type canonicalize(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return c.isArray() ? new GenericArrayTypeImpl(ParameterizedTypeImpl.canonicalize(c.getComponentType())) : c;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return new ParameterizedTypeImpl(p.getOwnerType(), p.getRawType(), p.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)type;
            return new GenericArrayTypeImpl(g.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            WildcardType w = (WildcardType)type;
            return new WildcardTypeImpl(w.getUpperBounds(), w.getLowerBounds());
        }
        return type;
    }

    static void checkArgument(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException();
        }
    }

    static String typeToString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    static int hashCodeOrZero(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.typeArguments.clone();
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public boolean equals(Object other) {
        return other instanceof ParameterizedType && Types.equals(this, (ParameterizedType)other);
    }

    public int hashCode() {
        return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ ParameterizedTypeImpl.hashCodeOrZero(this.ownerType);
    }

    public String toString() {
        int length = this.typeArguments.length;
        if (length == 0) {
            return ParameterizedTypeImpl.typeToString(this.rawType);
        }
        StringBuilder stringBuilder = new StringBuilder(30 * (length + 1));
        stringBuilder.append(ParameterizedTypeImpl.typeToString(this.rawType)).append("<").append(ParameterizedTypeImpl.typeToString(this.typeArguments[0]));
        for (int i = 1; i < length; ++i) {
            stringBuilder.append(", ").append(ParameterizedTypeImpl.typeToString(this.typeArguments[i]));
        }
        return stringBuilder.append(">").toString();
    }

    public static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        public GenericArrayTypeImpl(Type componentType) {
            this.componentType = ParameterizedTypeImpl.canonicalize(componentType);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public boolean equals(Object o) {
            return o instanceof GenericArrayType && Types.equals(this, (GenericArrayType)o);
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            return ParameterizedTypeImpl.typeToString(this.componentType) + "[]";
        }
    }

    public static final class WildcardTypeImpl
    implements WildcardType,
    Serializable {
        private final transient Type upperBound;
        private final transient Type lowerBound;
        private static final long serialVersionUID = 0L;

        public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            ParameterizedTypeImpl.checkArgument(lowerBounds.length <= 1);
            ParameterizedTypeImpl.checkArgument(upperBounds.length == 1);
            if (lowerBounds.length == 1) {
                Preconditions.checkNotNull(lowerBounds[0]);
                ParameterizedTypeImpl.checkNotPrimitive(lowerBounds[0]);
                ParameterizedTypeImpl.checkArgument(upperBounds[0] == Object.class);
                this.lowerBound = ParameterizedTypeImpl.canonicalize(lowerBounds[0]);
                this.upperBound = Object.class;
            } else {
                Preconditions.checkNotNull(upperBounds[0]);
                ParameterizedTypeImpl.checkNotPrimitive(upperBounds[0]);
                this.lowerBound = null;
                this.upperBound = ParameterizedTypeImpl.canonicalize(upperBounds[0]);
            }
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public Type[] getLowerBounds() {
            Type[] typeArray;
            if (this.lowerBound != null) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = this.lowerBound;
            } else {
                typeArray = EMPTY_TYPE_ARRAY;
            }
            return typeArray;
        }

        public boolean equals(Object other) {
            return other instanceof WildcardType && Types.equals(this, (WildcardType)other);
        }

        public int hashCode() {
            return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
        }

        public String toString() {
            if (this.lowerBound != null) {
                return "? super " + ParameterizedTypeImpl.typeToString(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + ParameterizedTypeImpl.typeToString(this.upperBound);
        }
    }
}

