/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.reflect.type;

import com.jn.langx.util.Preconditions;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Primitives {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPE;
    private static final HashMap<String, Class<?>> primClasses;

    private Primitives() {
    }

    private static void add(Map<Class<?>, Class<?>> forward, Map<Class<?>, Class<?>> backward, Class<?> key, Class<?> value) {
        forward.put(key, value);
        backward.put(value, key);
    }

    public static boolean isPrimitive(Type type) {
        return PRIMITIVE_TO_WRAPPER_TYPE.containsKey(type);
    }

    public static boolean isWrapperType(Type type) {
        return WRAPPER_TO_PRIMITIVE_TYPE.containsKey(Preconditions.checkNotNull(type));
    }

    public static boolean isPrimitiveOrPrimitiveWrapperType(Type type) {
        return Primitives.isPrimitive(type) || Primitives.isWrapperType(type);
    }

    public static <T> Class<T> wrap(Class<T> type) {
        Class<?> wrapped = PRIMITIVE_TO_WRAPPER_TYPE.get(Preconditions.checkNotNull(type));
        return wrapped == null ? type : wrapped;
    }

    public static Class wrap(Type type) {
        if (Primitives.isPrimitive(type)) {
            return PRIMITIVE_TO_WRAPPER_TYPE.get(Preconditions.checkNotNull(type));
        }
        return (Class)type;
    }

    public static <T> Class<T> unwrap(Class<T> type) {
        Class<?> unwrapped = WRAPPER_TO_PRIMITIVE_TYPE.get(Preconditions.checkNotNull(type));
        return unwrapped == null ? type : unwrapped;
    }

    public static short sizeOf(Class<?> type) {
        Preconditions.checkArgument(Primitives.isPrimitive(type));
        if (type == Boolean.TYPE || type == Byte.TYPE) {
            return 1;
        }
        if (type == Character.TYPE || type == Short.TYPE) {
            return 2;
        }
        if (type == Integer.TYPE || type == Float.TYPE) {
            return 4;
        }
        if (type == Long.TYPE || type == Double.TYPE) {
            return 8;
        }
        return 0;
    }

    public static boolean isIntegerCompatible(Class clazz) {
        return Primitives.isInteger(clazz) || Primitives.isByte(clazz) || Primitives.isShort(clazz);
    }

    public static boolean isChar(Type type) {
        return type == Character.TYPE || type == Character.class;
    }

    public static boolean isByte(Type type) {
        return type == Byte.TYPE || type == Byte.class;
    }

    public static boolean isShort(Type type) {
        return type == Short.TYPE || type == Short.class;
    }

    public static boolean isInteger(Type type) {
        return type == Integer.TYPE || type == Integer.class;
    }

    public static boolean isLong(Type type) {
        return type == Long.TYPE || type == Long.class;
    }

    public static boolean isFloat(Type type) {
        return type == Float.TYPE || type == Float.class;
    }

    public static boolean isDouble(Type type) {
        return type == Double.TYPE || type == Double.class;
    }

    public static boolean isBoolean(Type type) {
        return type == Boolean.TYPE || type == Boolean.class;
    }

    public static Class get(String name) {
        return primClasses.get(name);
    }

    static {
        primClasses = new HashMap(8, 1.0f);
        HashMap primToWrap = new HashMap(16);
        HashMap wrapToPrim = new HashMap(16);
        Primitives.add(primToWrap, wrapToPrim, Boolean.TYPE, Boolean.class);
        Primitives.add(primToWrap, wrapToPrim, Byte.TYPE, Byte.class);
        Primitives.add(primToWrap, wrapToPrim, Character.TYPE, Character.class);
        Primitives.add(primToWrap, wrapToPrim, Double.TYPE, Double.class);
        Primitives.add(primToWrap, wrapToPrim, Float.TYPE, Float.class);
        Primitives.add(primToWrap, wrapToPrim, Integer.TYPE, Integer.class);
        Primitives.add(primToWrap, wrapToPrim, Long.TYPE, Long.class);
        Primitives.add(primToWrap, wrapToPrim, Short.TYPE, Short.class);
        Primitives.add(primToWrap, wrapToPrim, Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap(primToWrap);
        WRAPPER_TO_PRIMITIVE_TYPE = Collections.unmodifiableMap(wrapToPrim);
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }
}

