/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.regexp;

import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.regexp.MatcherWatchdog;
import com.jn.langx.util.regexp.RegexpMatcher;
import com.jn.langx.util.timing.clock.Clock;
import com.jn.langx.util.timing.clock.SystemClock;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultMatcherWatchdog
implements MatcherWatchdog {
    private final long interval;
    private final long maxExecutionTime;
    private final Clock clock;
    private final Consumer2<Long, Runnable> scheduler;
    private final AtomicInteger registered = new AtomicInteger(0);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ConcurrentHashMap<RegexpMatcher, Long> registry = new ConcurrentHashMap();

    public DefaultMatcherWatchdog(long intervalInMills, long maxExecutionTime, Consumer2<Long, Runnable> schedulerProxy) {
        this(intervalInMills, maxExecutionTime, new SystemClock(), schedulerProxy);
    }

    public DefaultMatcherWatchdog(long intervalInMills, long maxExecutionTime, Clock clock, Consumer2<Long, Runnable> schedulerProxy) {
        this.interval = intervalInMills;
        this.maxExecutionTime = maxExecutionTime;
        this.clock = clock;
        this.scheduler = schedulerProxy;
    }

    @Override
    public void register(RegexpMatcher matcher) {
        this.registered.getAndIncrement();
        Long previousValue = this.registry.put(matcher, this.clock.getTime());
        if (this.running.compareAndSet(false, true)) {
            this.scheduler.accept(this.interval, this.createInterruptTask());
        }
        assert (previousValue == null);
    }

    @Override
    public long maxExecutionTimeInMillis() {
        return this.maxExecutionTime;
    }

    @Override
    public void unregister(RegexpMatcher matcher) {
        this.registry.remove(matcher);
        this.registered.decrementAndGet();
    }

    private void interruptLongRunningExecutions() {
        long currentTime = this.clock.getTime();
        for (Map.Entry<RegexpMatcher, Long> entry : this.registry.entrySet()) {
            long deadline = entry.getValue();
            if (currentTime - deadline <= this.maxExecutionTime) continue;
            entry.getKey().interrupt();
        }
        if (this.registered.get() > 0) {
            this.scheduler.accept(this.interval, this.createInterruptTask());
        } else {
            this.running.set(false);
        }
    }

    private Runnable createInterruptTask() {
        return new Runnable(){

            @Override
            public void run() {
                DefaultMatcherWatchdog.this.interruptLongRunningExecutions();
            }
        };
    }
}

