/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.regexp.jdk;

import com.jn.langx.util.Objs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.regexp.RegexpMatcher;
import com.jn.langx.util.regexp.jdk.JdkRegexp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

class JdkMatcher
implements RegexpMatcher {
    private Matcher matcher;
    private JdkRegexp regexp;

    JdkMatcher(JdkRegexp regexp, Matcher matcher) {
        this.regexp = regexp;
        this.matcher = matcher;
    }

    @Override
    public boolean matches() {
        return this.matcher.matches();
    }

    @Override
    public int start() {
        return this.matcher.start();
    }

    @Override
    public int start(int group) {
        return this.matcher.start(group);
    }

    @Override
    public int end() {
        return this.matcher.end();
    }

    @Override
    public int end(int group) {
        return this.matcher.end(group);
    }

    @Override
    public String group() {
        return this.matcher.group();
    }

    @Override
    public String group(int group) {
        return this.matcher.group(group);
    }

    @Override
    public String group(String groupName) {
        return this.matcher.group(groupName);
    }

    @Override
    public int start(String groupName) {
        return this.matcher.start(groupName);
    }

    @Override
    public int end(String groupName) {
        return this.matcher.end(groupName);
    }

    @Override
    public RegexpMatcher reset() {
        this.matcher.reset();
        return this;
    }

    @Override
    public RegexpMatcher reset(CharSequence content) {
        this.matcher.reset(content);
        return this;
    }

    @Override
    public boolean find() {
        return this.matcher.find();
    }

    @Override
    public boolean find(int start) {
        return this.matcher.find(start);
    }

    @Override
    public RegexpMatcher appendReplacement(StringBuilder b, String replacement) {
        StringBuffer buf = new StringBuffer();
        this.matcher.appendReplacement(buf, replacement);
        b.append(buf.toString());
        return this;
    }

    @Override
    public void appendTail(StringBuilder b) {
        StringBuffer buf = new StringBuffer();
        this.matcher.appendTail(buf);
        b.append(buf.toString());
    }

    @Override
    public int groupCount() {
        return this.matcher.groupCount();
    }

    @Override
    public List<Map<String, String>> namedGroups() {
        List<String> names = this.names();
        if (Objs.isEmpty(names)) {
            return Collects.emptyArrayList();
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        int nextIndex = 0;
        while (this.matcher.find(nextIndex)) {
            LinkedHashMap<String, String> matches = new LinkedHashMap<String, String>();
            for (String groupName : names) {
                String groupValue = this.matcher.group(groupName);
                matches.put(groupName, groupValue);
                nextIndex = this.matcher.end();
            }
            result.add(matches);
            if (!this.matcher.hitEnd()) continue;
            break;
        }
        return result;
    }

    @Override
    public List<String> names() {
        return Collects.asList(this.regexp.getNamedGroups());
    }

    @Override
    public void interrupt() {
    }
}

