/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.regexp.jdk;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Lists;
import com.jn.langx.util.comparator.OrderedComparator;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.regexp.Groups;
import com.jn.langx.util.regexp.Option;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.RegexpMatcher;
import com.jn.langx.util.regexp.jdk.JdkMatcher;
import com.jn.langx.util.struct.Holder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class JdkRegexp
implements Regexp {
    private static final Logger logger = Loggers.getLogger(JdkRegexp.class);
    private Pattern pattern;
    private Option option;
    private Holder<List<String>> namedGroups;
    private static final Method NAMED_GROUP_MAP_METHOD = Reflects.getDeclaredMethod(Pattern.class, "namedGroups", Emptys.EMPTY_CLASSES);

    public JdkRegexp(Pattern pattern) {
        this.pattern = pattern;
        this.option = Option.buildOption(pattern.flags());
    }

    public JdkRegexp(String pattern) {
        this.pattern = Pattern.compile(pattern, 0);
    }

    public JdkRegexp(String pattern, Option option) {
        this(pattern, option.toFlags());
    }

    public JdkRegexp(String pattern, int flags) {
        this.pattern = Pattern.compile(pattern, flags);
        this.option = Option.buildOption(flags);
    }

    @Override
    public Option getOption() {
        return this.option;
    }

    @Override
    public String getPattern() {
        return this.pattern.pattern();
    }

    @Override
    public RegexpMatcher matcher(CharSequence input) {
        return new JdkMatcher(this, this.pattern.matcher(input));
    }

    @Override
    public String[] split(CharSequence input) {
        return this.split(input, 0);
    }

    @Override
    public String[] split(CharSequence input, int limit) {
        return this.pattern.split(input, limit);
    }

    public String toString() {
        return this.getPattern();
    }

    @Override
    public List<String> getNamedGroups() {
        if (this.namedGroups == null) {
            List<String> groups;
            Map _map = null;
            try {
                if (NAMED_GROUP_MAP_METHOD != null) {
                    _map = (Map)Reflects.invoke(NAMED_GROUP_MAP_METHOD, this.pattern, Emptys.EMPTY_OBJECTS, true, true);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            final Map groupInfoByReflect = _map;
            if (groupInfoByReflect != null) {
                TreeSet<String> set = new TreeSet<String>(new OrderedComparator<String>(new Supplier<String, Integer>(){

                    @Override
                    public Integer get(String groupName) {
                        return (Integer)groupInfoByReflect.get(groupName);
                    }
                }));
                set.addAll(groupInfoByReflect.keySet());
                groups = Lists.immutableList(set);
            } else {
                Map<String, List<Groups.GroupCoordinate>> scannedGroupInfo = Groups.extractGroupInfo(this.pattern.pattern());
                groups = Lists.newArrayList(scannedGroupInfo.keySet());
            }
            this.namedGroups = new Holder<ArrayList<String>>((ArrayList<String>)groups);
        }
        return this.namedGroups.get();
    }
}

