/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.regexp.named;

import com.jn.langx.util.collection.Lists;
import com.jn.langx.util.regexp.Groups;
import com.jn.langx.util.regexp.RegexpMatcher;
import com.jn.langx.util.regexp.named.NamedRegexp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class NamedMatcher
implements RegexpMatcher {
    private Matcher matcher;
    private NamedRegexp parentPattern;

    NamedMatcher(NamedRegexp parentPattern, Matcher matcher) {
        this.parentPattern = parentPattern;
        this.matcher = matcher;
    }

    NamedMatcher(NamedRegexp parentPattern, MatchResult matcher) {
        this.parentPattern = parentPattern;
        this.matcher = (Matcher)matcher;
    }

    NamedMatcher(NamedRegexp parentPattern, CharSequence input) {
        this.parentPattern = parentPattern;
        this.matcher = parentPattern.pattern().matcher(input);
    }

    public Pattern standardPattern() {
        return this.matcher.pattern();
    }

    public NamedRegexp namedPattern() {
        return this.parentPattern;
    }

    public NamedMatcher usePattern(NamedRegexp newPattern) {
        if (newPattern == null) {
            throw new IllegalArgumentException("newPattern cannot be null");
        }
        this.parentPattern = newPattern;
        this.matcher.usePattern(newPattern.pattern());
        return this;
    }

    @Override
    public RegexpMatcher reset() {
        this.matcher.reset();
        return this;
    }

    @Override
    public NamedMatcher reset(CharSequence input) {
        this.matcher.reset(input);
        return this;
    }

    @Override
    public boolean matches() {
        return this.matcher.matches();
    }

    public RegexpMatcher toMatchResult() {
        return new NamedMatcher(this.parentPattern, this.matcher);
    }

    @Override
    public boolean find() {
        return this.matcher.find();
    }

    @Override
    public boolean find(int start) {
        return this.matcher.find(start);
    }

    public boolean lookingAt() {
        return this.matcher.lookingAt();
    }

    @Override
    public RegexpMatcher appendReplacement(StringBuilder sb, String replacement) {
        StringBuffer buf = new StringBuffer();
        this.matcher.appendReplacement(buf, this.parentPattern.replaceProperties(replacement));
        sb.append(buf.toString());
        return this;
    }

    @Override
    public void appendTail(StringBuilder sb) {
        StringBuffer buf = new StringBuffer();
        this.matcher.appendTail(buf);
        sb.append(buf.toString());
    }

    @Override
    public String group() {
        return this.matcher.group();
    }

    @Override
    public String group(int group) {
        return this.matcher.group(group);
    }

    @Override
    public int groupCount() {
        return this.matcher.groupCount();
    }

    public List<String> orderedGroups() {
        int groupCount = this.groupCount();
        ArrayList<String> groups = new ArrayList<String>(groupCount);
        for (int i = 1; i <= groupCount; ++i) {
            groups.add(this.group(i));
        }
        return groups;
    }

    @Override
    public String group(String groupName) {
        int idx = Groups.groupIndex(this.parentPattern.getGroupInfo(), groupName);
        if (idx < 0) {
            throw new IndexOutOfBoundsException("No group \"" + groupName + "\"");
        }
        return this.group(idx);
    }

    @Override
    public List<Map<String, String>> namedGroups() {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        List<String> groupNames = this.parentPattern.getNamedGroups();
        if (groupNames.isEmpty()) {
            return result;
        }
        int nextIndex = 0;
        while (this.matcher.find(nextIndex)) {
            LinkedHashMap<String, String> matches = new LinkedHashMap<String, String>();
            for (String groupName : groupNames) {
                String groupValue = this.matcher.group(Groups.groupIndex(this.parentPattern.getGroupInfo(), groupName));
                matches.put(groupName, groupValue);
                nextIndex = this.matcher.end();
            }
            result.add(matches);
            if (!this.matcher.hitEnd()) continue;
            break;
        }
        return result;
    }

    @Override
    public List<String> names() {
        return Lists.newArrayList();
    }

    @Override
    public int start() {
        return this.matcher.start();
    }

    @Override
    public int start(int group) {
        return this.matcher.start(group);
    }

    @Override
    public int start(String groupName) {
        return this.start(Groups.groupIndex(this.parentPattern.getGroupInfo(), groupName));
    }

    @Override
    public int end() {
        return this.matcher.end();
    }

    @Override
    public int end(int group) {
        return this.matcher.end(group);
    }

    @Override
    public int end(String groupName) {
        return this.end(Groups.groupIndex(this.parentPattern.getGroupInfo(), groupName));
    }

    public NamedMatcher region(int start, int end) {
        this.matcher.region(start, end);
        return this;
    }

    public int regionEnd() {
        return this.matcher.regionEnd();
    }

    public int regionStart() {
        return this.matcher.regionStart();
    }

    public boolean hitEnd() {
        return this.matcher.hitEnd();
    }

    public boolean requireEnd() {
        return this.matcher.requireEnd();
    }

    public boolean hasAnchoringBounds() {
        return this.matcher.hasAnchoringBounds();
    }

    public boolean hasTransparentBounds() {
        return this.matcher.hasTransparentBounds();
    }

    public String replaceAll(String replacement) {
        String r = this.parentPattern.replaceProperties(replacement);
        return this.matcher.replaceAll(r);
    }

    public String replaceFirst(String replacement) {
        return this.matcher.replaceFirst(this.parentPattern.replaceProperties(replacement));
    }

    public NamedMatcher useAnchoringBounds(boolean b) {
        this.matcher.useAnchoringBounds(b);
        return this;
    }

    public NamedMatcher useTransparentBounds(boolean b) {
        this.matcher.useTransparentBounds(b);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamedMatcher)) {
            return false;
        }
        NamedMatcher other = (NamedMatcher)obj;
        if (!this.parentPattern.equals(other.parentPattern)) {
            return false;
        }
        return this.matcher.equals(other.matcher);
    }

    public int hashCode() {
        return this.parentPattern.hashCode() ^ this.matcher.hashCode();
    }

    public String toString() {
        return this.matcher.toString();
    }

    @Override
    public void interrupt() {
    }
}

