/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.regexp.named;

import com.jn.langx.util.collection.Lists;
import com.jn.langx.util.regexp.Groups;
import com.jn.langx.util.regexp.Option;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.RegexpMatcher;
import com.jn.langx.util.regexp.named.NamedMatcher;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class NamedRegexp
implements Regexp,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    private Pattern pattern;
    private String namedPattern;
    private List<String> groupNames;
    private Map<String, List<Groups.GroupCoordinate>> groupInfo;
    private Option option;

    public NamedRegexp(String regex, int flags) {
        this.namedPattern = regex;
        this.groupInfo = Groups.extractGroupInfo(regex);
        this.pattern = this.buildStandardPattern(regex, flags);
        this.option = Option.buildOption(flags);
    }

    @Override
    public Option getOption() {
        return this.option;
    }

    public static NamedRegexp compile(String regex) {
        return new NamedRegexp(regex, 0);
    }

    public NamedRegexp(Pattern pattern) {
        this(pattern.pattern(), pattern.flags());
    }

    public NamedRegexp(String pattern) {
        this(pattern, 0);
    }

    public static NamedRegexp compile(String regex, int flags) {
        return new NamedRegexp(regex, flags);
    }

    public int flags() {
        return this.pattern.flags();
    }

    @Override
    public RegexpMatcher matcher(CharSequence input) {
        return new NamedMatcher(this, input);
    }

    @Override
    public String getPattern() {
        return this.namedPattern;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public static String quote(String s) {
        return Pattern.quote(s);
    }

    @Override
    public List<String> getNamedGroups() {
        if (this.groupNames == null) {
            this.groupNames = Lists.newArrayList(this.groupInfo.keySet());
        }
        return Collections.unmodifiableList(this.groupNames);
    }

    Map<String, List<Groups.GroupCoordinate>> getGroupInfo() {
        return this.groupInfo;
    }

    String replaceProperties(String replacementPattern) {
        return this.replaceGroupNameWithIndex(new StringBuilder(replacementPattern), Groups.PROPERTY_PATTERN, "$").toString();
    }

    @Override
    public String[] split(CharSequence input, int limit) {
        return this.pattern.split(input, limit);
    }

    @Override
    public String[] split(CharSequence input) {
        return this.pattern.split(input);
    }

    public String toString() {
        return this.namedPattern;
    }

    private static StringBuilder replace(StringBuilder input, Pattern pattern, String replacement) {
        Matcher m = pattern.matcher(input);
        while (m.find()) {
            if (Groups.isEscapedChar(input.toString(), m.start())) continue;
            input.replace(m.start(), m.end(), replacement);
            m.reset(input);
        }
        return input;
    }

    private StringBuilder replaceGroupNameWithIndex(StringBuilder input, Pattern pattern, String prefix) {
        Matcher m = pattern.matcher(input);
        while (m.find()) {
            if (Groups.isEscapedChar(input.toString(), m.start())) continue;
            int index = Groups.indexOf(this.groupInfo, m.group(1));
            if (index < 0) {
                throw new PatternSyntaxException("unknown group name", input.toString(), m.start(1));
            }
            input.replace(m.start(), m.end(), prefix + ++index);
            m.reset(input);
        }
        return input;
    }

    private Pattern buildStandardPattern(String namedPattern, Integer flags) {
        StringBuilder s = new StringBuilder(namedPattern);
        s = NamedRegexp.replace(s, Groups.NAMED_GROUP_PATTERN, "(");
        s = this.replaceGroupNameWithIndex(s, Groups.BACKREF_NAMED_GROUP_PATTERN, "\\");
        return Pattern.compile(s.toString(), flags);
    }

    private boolean groupInfoMatches(Map<String, List<Groups.GroupCoordinate>> a, Map<String, List<Groups.GroupCoordinate>> b) {
        if (a == null && b == null) {
            return true;
        }
        boolean isMatch = false;
        if (a != null && b != null) {
            if (a.isEmpty() && b.isEmpty()) {
                isMatch = true;
            } else if (a.size() == b.size()) {
                for (Map.Entry<String, List<Groups.GroupCoordinate>> entry : a.entrySet()) {
                    List<Groups.GroupCoordinate> thisList;
                    List<Groups.GroupCoordinate> otherList = b.get(entry.getKey());
                    boolean bl = isMatch = otherList != null;
                    if (isMatch && (isMatch = otherList.containsAll(thisList = entry.getValue()) && thisList.containsAll(otherList))) continue;
                    break;
                }
            }
        }
        return isMatch;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamedRegexp)) {
            return false;
        }
        NamedRegexp other = (NamedRegexp)obj;
        boolean groupNamesMatch = this.groupNames == null && other.groupNames == null || this.groupNames != null && !Collections.disjoint(this.groupNames, other.groupNames);
        boolean groupInfoMatch = groupNamesMatch && this.groupInfoMatches(this.groupInfo, other.groupInfo);
        return groupNamesMatch && groupInfoMatch && this.namedPattern.equals(other.namedPattern) && this.pattern.flags() == other.pattern.flags();
    }

    public int hashCode() {
        int hash = this.namedPattern.hashCode() ^ this.pattern.hashCode();
        if (this.groupInfo != null) {
            hash ^= this.groupInfo.hashCode();
        }
        if (this.groupNames != null) {
            hash ^= this.groupNames.hashCode();
        }
        return hash;
    }
}

