/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.retry;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.concurrent.threadlocal.GlobalThreadLocalMap;
import com.jn.langx.util.retry.RetryConfig;

public abstract class BackoffPolicy {
    public final long getBackoffTime(RetryConfig config, int attempts) {
        long backoffTime = this.getBackoffTimeInternal(config, attempts);
        Preconditions.checkTrue(backoffTime >= 0L, "invalid backoff");
        long backoffTimeMils = config.getTimeUnit().toMillis(backoffTime);
        backoffTimeMils = this.addJitter(backoffTimeMils, config.getJitter());
        long maxSleepTimeMils = config.getMaxSleepTime() > 0L ? config.getTimeUnit().toMillis(config.getMaxSleepTime()) : -1L;
        backoffTimeMils = maxSleepTimeMils > 0L ? Math.min(backoffTimeMils, maxSleepTimeMils) : backoffTimeMils;
        return backoffTimeMils;
    }

    protected long getBackoffTimeInternal(RetryConfig config, int attempts) {
        long backoffTime = config.getSleepInterval();
        return backoffTime;
    }

    private long addJitter(long interval, float jitter) {
        long jitterInterval = (long)((float)interval * GlobalThreadLocalMap.getRandom().nextFloat() * jitter);
        return interval + jitterInterval;
    }
}

