/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.retry;

public class RetryInfo<R> {
    private int attempts;
    private final int maxAttempts;
    private final long startTime;
    private final long timeout;
    private long backoff = -1L;
    private Throwable error;
    private R result;

    public RetryInfo(int attempts, int maxAttempts, long startTime, long timeout) {
        this.attempts = attempts;
        this.maxAttempts = maxAttempts;
        this.startTime = startTime;
        this.timeout = timeout;
    }

    public RetryInfo(int attempt, int maxAttempts, long backoff) {
        this(attempt, maxAttempts, System.currentTimeMillis(), 0L);
        this.setBackoff(backoff);
    }

    void setBackoff(long backoff) {
        this.backoff = backoff;
    }

    public int getRetryCount() {
        return this.attempts - 1;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public int getMaxAttempts() {
        if (this.isInfiniteRetriesLeft()) {
            return Integer.MAX_VALUE;
        }
        return -1;
    }

    public int getAttemptsLeft() {
        if (this.isInfiniteRetriesLeft()) {
            return Integer.MAX_VALUE;
        }
        return this.getMaxAttempts() - this.attempts;
    }

    private boolean isInfiniteRetriesLeft() {
        return this.maxAttempts <= 0;
    }

    public long getBackoff() {
        return this.backoff;
    }

    public boolean isLastAttempts() {
        if (this.isInfiniteRetriesLeft()) {
            return false;
        }
        return this.getMaxAttempts() - 1 == this.attempts;
    }

    public boolean isFirstAttempts() {
        return this.attempts == 1;
    }

    public RetryInfo<R> nextAttempts() {
        ++this.attempts;
        this.backoff = -1L;
        this.error = null;
        this.result = null;
        return this;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Throwable getError() {
        return this.error;
    }

    void setError(Throwable error) {
        this.error = error;
        this.result = null;
    }

    public R getResult() {
        return this.result;
    }

    void setResult(R result) {
        this.result = result;
        this.error = null;
    }

    public boolean hasError() {
        return this.error != null;
    }
}

